
struct aagun {
	ABITMAP *hold;
	ABITMAP *barrel;
	ABITMAP *base;
	ABITMAP *baseo;
	ABITMAP *baseoe;
	ABITMAP *gunbg;
	float angle;
	float fangle;
	float dangle;
	float x, y;
	int offx, offy;
	int w, h;
	float speed;
	bool direction;
	bool occupied;
	bool destroyed;
	soldier *driver;
	int fired;
	float bulletforce;
	int numfired;
	bool drew;

	bool *fire;
	float tx, ty;

	aagun() {
		hold = NULL;
		reset();
	}

	void reset() {
		angle = 192;
		fangle = 192;
		dangle = 0;
		speed = 0.1;
		direction = RIGHT;
		occupied = false;
		destroyed = false;
		tx = ty = 0;
		fired = 0;
		bulletforce = 15;
		numfired = 0;
		if(hold != NULL) clear_to_color(hold, magenta);
		drew = false;
	}


	void init(float nx, float ny) {
		x = nx;
		y = ny;
		offx = 8;
		offy = 26;
		w = 63;
		h = 43;
		hold = create_bitmap(w, h);
		clear_to_color(hold, magenta);
		tx = x + 10;
		ty = y;
	}

	void getin(soldier *newdriver) {
		driver = newdriver;
		if(destroyed) return;
		if(occupied == false) {
			occupied = true;
		}
		else {
			occupied = false;
		}
	}

	void update();

	void draw();

	void erase() {
		if(!drew) return;
		blit(bg, buf, x, y, x, y, w, h);
		drew = false;
	}
};

aagun aaguns[MAXAAGUNS];
int numaaguns;

aagun *addaagun(float x, float y) {
	aagun *a;
	a = &(aaguns[numaaguns]);
	numaaguns++;
	a->init(x, y);
	return a;
}

void drawaaguns() {
	aagun *a;
	int i;
	a = &(aaguns[0]);
	for(i = 0; i < numaaguns; i++) {
		a->draw();
		a++;
	}
}

void updateaaguns() {
	aagun *a;
	int i;
	a = &(aaguns[0]);
	for(i = 0; i < numaaguns; i++) {
		a->update();
		a++;
	}
}	

void eraseaaguns() {
	aagun *a;
	int i;
	a = &(aaguns[0]);
	for(i = 0; i < numaaguns; i++) {
		a->erase();
		a++;
	}
}

struct jeep {
	rigidbody *me;
	bool occupied;
	float strength;
	object *myobj;
	ABITMAP *unoc;
	ABITMAP *unocl;
	ABITMAP *occ;
	ABITMAP *occl;
	ABITMAP *exp;
	ABITMAP *expl;
	float damage;
	soldier *driver;

	bool *keyleft;
	bool *keyright;
	bool *keyup;
	bool *keydown;

	bool direction;
	int engvoice;
	int engstartvoice;
	bool engstarted;
	bool destroyed;
	bool on;

	jeep() {
		reset();
	}

	void reset() {
		occupied = false;
		//strength = 0.06;
		strength = 0.1;
		keyleft = &(keys['A']);
		keyright = &(keys['D']);
		keyup = &(keys['W']);
		keydown = &(keys['S']);
		direction = RIGHT;
		destroyed = false;
		damage = 0;
		driver = NULL;
		on = false;
	}

	void init() {
		dovoices();
	}

	void killvoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = NULL;
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = NULL;
	}

	void dovoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = allocate_voice(engine);
		voice_set_playmode(engvoice, PLAYMODE_LOOP);
		voice_start(engvoice);
		voice_set_volume(engvoice, 0);
		voice_set_priority(engvoice, 255);
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = allocate_voice(enginestart);
		voice_stop(engstartvoice);
	}

	void getin(soldier *newdriver) {
		driver = newdriver;
		if(destroyed) return;
		if(occupied == false) {
			occupied = true;
			if(voice_check(engstartvoice) != enginestart) dovoices();
			voice_start(engstartvoice);
			dopanvol(me->x, 0.5);
			voice_set_pan(engstartvoice, pan);
			voice_set_volume(engstartvoice, vol);
			release_voice(engstartvoice);
			engstarted = false;
			voice_set_position(engstartvoice, 0);
			//voice_ramp_volume(engvoice, 100, 255);
			if(direction == RIGHT)
				myobj->obj = occ;
			else
				myobj->obj = occl;
		}
		else {
			voice_ramp_volume(engvoice, 100, 0);
			occupied = false;
			engstarted = false;
			if(direction == RIGHT)
				myobj->obj = unoc;
			else
				myobj->obj = unocl;
		}
	}

	void dokeys() {
		if(destroyed) return;
		float appstrength;
		float dx, dy, d;

		if(!engstarted && voice_get_position(engstartvoice) >= 10000) {
			voice_ramp_volume(engvoice, 100, 255);
			engstarted = true;
		}

		dx = me->atomlist[3]->x - me->atomlist[0]->x;
		dy = me->atomlist[3]->y - me->atomlist[0]->y;
		d = sqrt(dx * dx + dy * dy);
		dx = dx / d;
		dy = dy / d;

		appstrength = strength * COMPFRAMES;

		dx *= appstrength;
		dy *= appstrength;		

		if(me->y > path[(int)me->x] - 20) {

			/*
			if(*keydown && !*keyup) {
				if(direction == RIGHT) {
					me->ix -= dx;
					me->iy -= dy;
				}
				else {
					me->ix += dx;
					me->iy += dy;
				}
			}
			else if(*keyup && !*keydown) {
				if(direction == LEFT) {
					me->ix -= dx;
					me->iy -= dy;
				}
				else {
					me->ix += dx;
					me->iy += dy;
				}
			}
			*/
			if(*keyleft && !*keyright && !*keydown) {
				me->ix -= dx;
				me->iy -= dy;
				if(direction != LEFT) {
					direction = LEFT;
					myobj->obj = occl;
				}
			}
			else if(*keyright && !*keyleft && !*keydown) {
				me->ix += dx;
				me->iy += dy;
				if(direction != RIGHT) {
					direction = RIGHT;
					myobj->obj = occ;
				}
			}
			else if(*keydown && !*keyleft && !*keyright) {
				if(direction == LEFT) {
					me->ix += dx;
					me->iy += dy;
				}
				else if(direction == RIGHT) {
					me->ix -= dx;
					me->iy -= dy;
				}
			}
			else {
				dx *= 0.4;
				dy *= 0.4;
				if(me->ix > dx) {
					me->ix -= dx;
					if(me->iy > dy)
						me->iy -= dy;
					else if(me->iy < -dy)
						me->iy += dy;
					else
						me->iy = 0;
				}
				else if(me->ix < -dx) {
					me->ix += dx;
					if(me->iy > dy)
						me->iy -= dy;
					else if(me->iy < -dy)
						me->iy += dy;
					else
						me->iy = 0;
				}
				else {
					me->ix = 0;
					if(me->iy > dy)
						me->iy -= dy;
					else if(me->iy < -dy)
						me->iy += dy;
					else
						me->iy = 0;
				}
			}
		}
	}

	void update();
};

jeep jeeps[MAXJEEPS];
int numjeeps;



void addjeep(float nx, float ny) {
	jeep *j;
	rigidbody *r;
	int x, y;

	j = &(jeeps[0]);
	while(j->on) j++;

	settmplevels();
	tmplevels[1] = false;
	tmplevels[3] = false;
	tmplevels[4] = false;
	tmplevels[7] = false;
	tmplevels[11] = false;
	tmplevels[12] = false;
	j->on = true;
	r = addrigidobject("graphics\\jeepu.tga", nx, ny, false, tmplevels, 7, 0.025, 0.001, 70, 1);
	r->afric = 0.95;
	j->me = r;
	j->myobj = &(objects[numobjects - 1]);
	r->imult = 3;
	for(x = 0; x < 100; x++) {
		for(y = 0; y < 100; y++) {
			if(atomstructure[x][y] != NULL) {
				atomstructure[x][y]->damage = &(j->damage);
			}
		}
	}
	j->init();
	if(j == &(jeeps[numjeeps]))
		numjeeps++;
}

void updatejeeps() {
	jeep *j;
	int i;
	j = &(jeeps[0]);
	for(i = 0; i < numjeeps; i++) {
		j->update();
		j++;
	}
}

jeep *byjeep(float x, float y) {
	jeep *j;
	int i;

	j = &(jeeps[0]);
	for(i = 0; i < numjeeps; i++) {
		if(	!j->destroyed && j->me != NULL && x < j->me->x + 8 && x > j->me->x - 8 &&
			y < j->me->y + 15 && y >= j->me->y) {
			return j;
		}
		j++;
	}
	return NULL;
}

struct tank {
	rigidbody *me;
	bool occupied;
	float strength;
	float engspeed;
	object *myobj;
	ABITMAP *base;
	ABITMAP *barrel;
	ABITMAP *exp;
	/*
	ABITMAP *base;
	ABITMAP *basel;
	ABITMAP *gunu;
	ABITMAP *gunul;
	ABITMAP *guno;
	ABITMAP *gunol;
	ABITMAP *exp;
	ABITMAP *expl;
	ABITMAP *barrel;
	ABITMAP *barrell;
	*/
	float damage;
	soldier *driver;

	bool *keyleft;
	bool *keyright;
	bool *keyup;
	bool *keydown;
	float tx, ty;
	bool *fire;

	//bool direction;
	//bool barreldirection;
	int engvoice;
	int engstartvoice;
	bool engstarted;
	bool destroyed;
	bool on;

	float speed;
	float barrelang;
	float goalang;
	//float cx, cy, 
	float x, y, ox, oy;
	float barrelspeed;
	float ca, sa, rca, rsa, oca, osa;
	float mk;				//just there for holdovers draw--dokeys

	int fired;
	int firing;

	float engramp;
	float engdir;

	tank() {
		reset();
	}

	void reset() {
		occupied = false;
		//strength = 2.5;
		//strength = 2.5;
		strength = 2.5;
		engspeed = 1;
		keyleft = &(keys['A']);
		keyright = &(keys['D']);
		keyup = &(keys['W']);
		keydown = &(keys['S']);
		destroyed = false;
		damage = 0;
		driver = NULL;
		on = false;
		speed = 0;
		barrelspeed = 1;
		fired = 0;
		barrel = tankbarrelanim[0];
		firing = 0;
		barrelang = 0;
		ca = 1;
		sa = 0;
		mk = 0;
		goalang = 0;
	}

	void init() {
		dovoices();
		barrel = tankbarrelanim[0];
		myobj->obj = base;
	}

	void killvoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = NULL;
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = NULL;
	}

	void dovoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = allocate_voice(engine);
		voice_set_playmode(engvoice, PLAYMODE_LOOP);
		voice_start(engvoice);
		voice_set_volume(engvoice, 0);
		voice_set_priority(engvoice, 255);
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = allocate_voice(enginestart);
		voice_stop(engstartvoice);
	}

	void getin(soldier *);

	void draw();

	void erase() {
		if(destroyed) return;
		//if(barreldirection == RIGHT) {
			//blit(bg, buf, x - 35, y - 35, x - 35, y - 35, 70, 70);
		//}
		blit(bg, buf, ox - 25, oy - 25, ox - 25, oy - 25, 50, 35);
		//rectfill(buf, x - 15, y - 17, x + 15, y - 5, magenta);
	}

	void dokeys();

	void update();
};

tank tanks[MAXTANKS];
int numtanks;

tank *addtank(float nx, float ny, bool comp) {
	tank *j;
	rigidbody *r;
	int x, y;

	j = &(tanks[0]);
	while(j->on) j++;
	j->reset();

	settmplevels();
	tmplevels[1] = false;
	tmplevels[3] = false;
	tmplevels[4] = false;
	tmplevels[5] = false;
	tmplevels[7] = false;
	tmplevels[9] = false;
	tmplevels[11] = false;
	tmplevels[12] = false;
	

	tmplevels[16] = false;
	tmplevels[17] = false;
	tmplevels[18] = false;
	tmplevels[19] = false;

	j->on = true;
	j->destroyed = false;
	j->damage = 0;
	//r = addrigidobject("tanku.tga", nx, ny, false, tmplevels, 7, 0.005, 0.0001, 100, 1);
	//r = addrigidobject("tanku.tga", nx, ny, false, tmplevels, 7, 0.025, 0.001, 70, 1);
	if(!comp) r = addrigidobject("graphics\\tankd.tga", nx, ny, false, tmplevels, 7, 0.005, 0.0001, 600, 1);
	else r = addrigidobject("graphics\\tankde.tga", nx, ny, false, tmplevels, 7, 0.005, 0.0001, 600, 1);
	r->grmult = 15;
	r->grounddamagethreshold = 20;

	//r->afric = 0.95;
	//r->gfric = 0.007;
	r->imult = 0.5;

	if(!comp) {
		j->base = tankbase;
		j->exp = tankd;
	}
	else {
		j->base = tankbasee;
		j->exp = tankde;
	}

	j->me = r;
	j->myobj = &(objects[numobjects - 1]);
	for(x = 0; x < 100; x++) {
		for(y = 0; y < 100; y++) {
			if(atomstructure[x][y] != NULL) {
				atomstructure[x][y]->damage = &(j->damage);
			}
		}
	}
	j->init();
	if(j == &(tanks[numtanks]))
		numtanks++;
	return j;
}

void updatetanks() {
	tank *j;
	int i;
	j = &(tanks[0]);
	for(i = 0; i < numtanks; i++) {
		if(j->on)
			j->update();
		j++;
	}
}

void drawtanks() {
	tank *j;
	int i;
	j = &(tanks[0]);
	for(i = 0; i < numtanks; i++) {
		if(j->on)
			j->draw();
		j++;
	}
}

void erasetanks() {
	tank *j;
	int i;
	j = &(tanks[0]);
	for(i = 0; i < numtanks; i++) {
		j->erase();
		j++;
	}
}

tank *bytank(float x, float y) {
	tank *j;
	int i;

	j = &(tanks[0]);
	for(i = 0; i < numtanks; i++) {
		if(!j->occupied && !j->destroyed && j->me != NULL && x < j->me->x + 8 && x > j->me->x - 8 &&
			y < j->me->y + 15 && y >= j->me->y) {
			return j;
		}
		j++;
	}
	return NULL;
}

int calcdiff(float a, float b) {
    float d1 = abs(a - b);
    float d2 = 256 - d1;
    if(d1 < d2) {
        if(a > b) return -d1;
        else return d1;
    }
    else {
        if(a < b) return -d2;
        else return d2;
    }
}

struct plane {
	rigidbody *me;
	bool occupied;
	float strength;
	float force;
	object *myobj;
	ABITMAP *unoc;
	ABITMAP *occ;
	ABITMAP *firing;
	ABITMAP *exp;
	ABITMAP *damaged;
	ABITMAP *damagedo;
	ABITMAP *damagedf;
	float damage;
	soldier *driver;

	bool *keyleft;
	bool *keyright;
	bool *keyslow;
	bool *keyup;
	bool *keydown;

	bool direction;
	int engvoice;
	int engstartvoice;
	bool engstarted;
	bool destroyed;
	bool on;
	float speed;
	float engspeed, goalspeed;
	float proprot;
	float dx, dy, rx, ry;
	int fired;
	int bfired;
	float sadd;
	float turning;
	float turnang;
	bool inturn;
	float tcos;
	bool noturn;
	bool isdamaged;
	float xch, ych;
	float oldspeed;
	float tx, ty;
	bool *fire;
	bool *dropbomb;

	bool drew;

	float engramp;
	float engdir;

	plane() {
		reset();
	}

	void reset() {
		occupied = false;
		strength = 0.3;
		force = 40;
		keyleft = &(keys['A']);
		keyright = &(keys['D']);
		keyup = &(keys['W']);
		keydown = &(keys['S']);
		direction = RIGHT;
		destroyed = false;
		damage = 0;
		driver = NULL;
		on = false;
		engspeed = 0;
		goalspeed = 0;
		proprot = pi / 2;
		goalspeed = 0;
		fired = 0;
		sadd = 0;
		turning = 0;
		direction = RIGHT;
		tcos = 1;
		noturn = false;
		turning = 0;
		turnang = 0;
		inturn = false;
		isdamaged = false;
		xch = ych = 0;
		tx = ty = 0;
		fire = NULL;
		dropbomb = NULL;
		engramp = engdir = 0;
	}

	void init() {
		myobj->obj = unoc;
		dovoices();
		//addtrailanim(me->atomlist[1], smokeanim, 8, 3, rand()% 3, 100000, 0, 1, true, 3);
		//addtrailanim(me->atomlist[1], smokeanim, 8, 10, rand()% 10, 100000, 0, 1, true, 10);
		//addtrailanim(me->atomlist[1], smokeanim, 8, 10, rand()% 10, 100000, 0, 1, true, 10);
	}

	void killvoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = NULL;
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = NULL;
	}

	void dovoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = allocate_voice(prop);
		voice_set_playmode(engvoice, PLAYMODE_LOOP);
		voice_start(engvoice);
		voice_set_volume(engvoice, 0);
		voice_set_priority(engvoice, 255);
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = allocate_voice(propstart);
		voice_stop(engstartvoice);
	}

	void getin(soldier *newdriver);

	void draw() {
		if(me == NULL) return;

		if(me->x + 50 > lx && me->x - 50 < rx) {

			float cx, cy, ox, oy, o;
			int points[14];
			cx = me->polylistx[16] + dx*2*tcos + rx*1;
			cy = me->polylisty[16] + dy*2*tcos + ry*1;
			o = sin(proprot);
			ox = o * rx;
			oy = o * ry;

			points[0] = (int)(cx);
			points[1] = (int)(cy);
			points[2] = (int)(cx - 7*ox - .5*dx);
			points[3] = (int)(cy - 7*oy - .5*dy);
			points[4] = (int)(cx - 7*ox + .5*dx);
			points[5] = (int)(cy - 7*oy + .5*dy);
			points[6] = (int)(cx);
			points[7] = (int)(cy);
			points[8] = (int)(cx + 7*ox - .5*dx);
			points[9] = (int)(cy + 7*oy - .5*dy);
			points[10] = (int)(cx + 7*ox + .5*dx);
			points[11] = (int)(cy + 7*oy + .5*dy);
			points[12] = (int)(cx);
			points[13] = (int)(cy);

			/*
			points[0] = (int)(cx + 0.5*dx);
			points[1] = (int)(cy + 0.5*dy);
			points[2] = (int)(cx - 7*ox);
			points[3] = (int)(cy - 7*oy);
			points[4] = (int)(cx - 7*ox + 1*dx);
			points[5] = (int)(cy - 7*oy + 1*dy);
			points[6] = (int)(cx + 0.5*dx);
			points[7] = (int)(cy + 0.5*dy);
			points[8] = (int)(cx + 7*ox);
			points[9] = (int)(cy + 7*oy);
			points[10] = (int)(cx + 7*ox + 1*dx);
			points[11] = (int)(cy + 7*oy + 1*dy);
			points[12] = (int)(cx + 0.5*dx);
			points[13] = (int)(cy + 0.5*dy);
			*/

			polygon(buf, 7, points, black);

			//lx = cx;
			//ly = cy;
			if(engstarted || !occupied)
				proprot += 0.02 * (0.5 * engspeed + sadd);

			if(destroyed) return; 

			/*
			atom *wa, *sa;

			wa = me->atomlist[me->mynumatoms - 2];
			sa = me->atomlist[me->mynumatoms - 1];

			line(buf, wa->x - rx*10, wa->y - ry*10, wa->x, wa->y, black);
			circlefill(buf, wa->x, wa->y, 2, gray);
			circle(buf, wa->x, wa->y, 2, black);

			line(buf, sa->x - rx*10, sa->y - ry*10, sa->x, sa->y, black);

			drew = true;
			*/
		}

		//line(buf, lx, ly, ux, uy, gray);

	}

	void erase() {
		if(drew == true) {
			if(me == NULL) return;
			float ox, oy;
			ox = me->atomlist[16]->x - me->x;
			oy = me->atomlist[16]->y - me->y;
			ox *= tcos;
			oy *= tcos;		
			blit(bg, buf, me->x + ox - 10, me->y + oy - 10, me->x + ox - 10, me->y + oy - 10, 20, 20);
			blit(bg, buf, me->atomlist[18]->x - 5, me->atomlist[18]->y - 5, me->atomlist[18]->x - 5, me->atomlist[18]->y - 5, 10, 10);
			blit(bg, buf, me->atomlist[19]->x - 5, me->atomlist[19]->y - 5, me->atomlist[19]->x - 5, me->atomlist[19]->y - 5, 10, 10);
			drew = false;
		}
	}

	void dokeys();

	void setdirection(bool newdir);

	void update();
};

plane planes[MAXPLANES];
int numplanes;


struct heli {
	rigidbody *me;
	bool occupied;
	float strength;
	float force;
	object *myobj;
	ABITMAP *unoc;
	ABITMAP *occ;
	ABITMAP *firing;
	ABITMAP *exp;
	ABITMAP *damaged;
	ABITMAP *damagedo;
	ABITMAP *damagedf;
	float damage;
	soldier *driver;

	bool *keyleft;
	bool *keyright;
	bool *keyup;
	bool *keydown;

	bool direction;
	int engvoice;
	int engstartvoice;
	bool engstarted;
	int engstartcount;
	bool destroyed;
	bool on;
	float speed;
	float engspeed, goalspeed;
	float proprot;
	float dx, dy, rx, ry;
	int fired;
	int bfired;
	float sadd;
	float turning;
	float turnang;
	bool inturn;
	float tcos;
	bool noturn;
	bool isdamaged;
	float xch, ych;
	float oldspeed;
	float tx, ty;
	bool *fire;
	bool *dropbomb;
	float accx, accy;

	float engramp;
	float engdir;

	heli() {
		reset();
	}

	void reset() {
		accx = accy = 0;
		occupied = false;
		strength = 0.3;
		force = 40;
		keyleft = &(keys['A']);
		keyright = &(keys['D']);
		keyup = &(keys['W']);
		keydown = &(keys['S']);
		direction = RIGHT;
		destroyed = false;
		damage = 0;
		driver = NULL;
		on = false;
		engspeed = 0;
		goalspeed = 0;
		proprot = pi / 2;
		goalspeed = 0;
		fired = 0;
		sadd = 0;
		turning = 0;
		direction = RIGHT;
		tcos = 1;
		noturn = false;
		turning = 0;
		turnang = 0;
		inturn = false;
		isdamaged = false;
		xch = ych = 0;
		tx = ty = 0;
		fire = NULL;
		dropbomb = NULL;
		engstartcount = 0;
	}

	void init() {
		myobj->obj = unoc;
		dovoices();
		//addtrailanim(me->atomlist[1], smokeanim, 8, 3, rand()% 3, 100000, 0, 1, true, 3);
		//addtrailanim(me->atomlist[1], smokeanim, 8, 10, rand()% 10, 100000, 0, 1, true, 10);
		//addtrailanim(me->atomlist[1], smokeanim, 8, 10, rand()% 10, 100000, 0, 1, true, 10);
	}

	void killvoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = NULL;
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = NULL;
	}

	void dovoices() {
		if(engvoice != NULL) deallocate_voice(engvoice);
		engvoice = allocate_voice(prop);
		voice_set_playmode(engvoice, PLAYMODE_LOOP);
		voice_start(engvoice);
		voice_set_volume(engvoice, 0);
		voice_set_priority(engvoice, 255);
		if(engstartvoice != NULL) deallocate_voice(engstartvoice);
		engstartvoice = allocate_voice(propstart);
		voice_stop(engstartvoice);
	}

	void getin(soldier *newdriver);

	void draw() {
		if(me == NULL) return;
		float cx, cy, ox, oy, o;
		float points[14];
		float bx, by;
		bx = me->polylistx[13] + dx*2*tcos + rx*2;
		by = me->polylisty[13] + dy*2*tcos + ry*2;
		cx = me->polylistx[13] + dx*2*tcos;
		cy = me->polylisty[13] + dy*2*tcos;
		o = sin(proprot);
		ox = o * dx;
		oy = o * dy;

		points[0] = (cx);
		points[1] = (cy);
		points[2] = (cx - 20*ox - 1*rx);
		points[3] = (cy - 20*oy - 1*ry);
		points[4] = (cx - 20*ox + 1*rx);
		points[5] = (cy - 20*oy + 1*ry);
		points[6] = (cx - 0 * rx);
		points[7] = (cy - 0 * ry);
		points[8] = (cx + 20*ox + 1*rx);
		points[9] = (cy + 20*oy + 1*ry);
		points[10] = (cx + 20*ox - 1*rx);
		points[11] = (cy + 20*oy - 1*ry);
		points[12] = (cx);
		points[13] = (cy);
		line(buf, points[0], points[1], bx, by, black);

		glLineWidth(1.0f);
		glColor3f(0.0,0.0,0.0);
		glBegin(GL_LINES);		
			glVertex2f(points[0], points[1]);
			glVertex2f(points[2], points[3]);
			glVertex2f(points[2], points[3]);
			glVertex2f(points[4], points[5]);
			glVertex2f(points[4], points[5]);
			glVertex2f(points[6], points[7]);
			glVertex2f(points[6], points[7]);
			glVertex2f(points[8], points[9]);
			glVertex2f(points[8], points[9]);
			glVertex2f(points[10], points[11]);
			glVertex2f(points[10], points[11]);
			glVertex2f(points[12], points[13]);
		glEnd();

		glColor3f(0.2,0.2,0.2);
		glBegin(GL_POLYGON);
			glVertex2f(points[0], points[1]);
			glVertex2f(points[2], points[3]);
			glVertex2f(points[4], points[5]);
			glVertex2f(points[6], points[7]);
			glVertex2f(points[8], points[9]);
			glVertex2f(points[10], points[11]);
			glVertex2f(points[12], points[13]);
		glEnd();
		


		/*
		polygon(buf, 7, points, black);

		//lx = cx;
		//ly = cy;
		*/

		if(engstarted || !occupied)
			proprot += 0.02 * (80 * engspeed + sadd);

		if(destroyed) return;
	}

	void erase() {
		if(me == NULL) return;
		float cx, cy;
		cx = me->polylistx[13] + dx*2*tcos - rx*1;
		cy = me->polylisty[13] + dy*2*tcos - ry*1;		
		dx = fabs(dx);
		dy = fabs(dy);
		rx = fabs(rx);
		ry = fabs(ry);
		blit(bg, buf, cx - 25*dx - 5*rx, cy - 25*dy - 5*ry, cx - 25*dx - 5*rx, cy - 25*dy - 5*ry, 50*dx + 10*rx, 50*dy + 10*ry);
	}

	void dokeys();

	void setdirection(bool newdir);

	void update();
};

heli helis[MAXHELIS];
int numhelis;

heli *byheli(float x, float y) {
	heli *j;
	int i;

	j = &(helis[0]);
	for(i = 0; i < numhelis; i++) {
		if(	!j->destroyed && !j->occupied && x < j->me->x + 25 && x > j->me->x + 5 &&
			y < j->me->y + 15 && y >= j->me->y - 5) {
			return j;
		}
		j++;
	}
	return NULL;
}

heli *addheli(float nx, float ny, bool side) {
	heli *j;
	rigidbody *r;
	int x, y;

	j = &(helis[0]);
	while(j->on) j++;

	ny -= 100;
	settmplevels();
	tmplevels[1] = false;
	tmplevels[3] = false;
	tmplevels[4] = false;
	tmplevels[5] = false;
	tmplevels[7] = false;
	tmplevels[9] = false;
	tmplevels[11] = false;
	tmplevels[12] = false;

	

	tmplevels[16] = false;
	tmplevels[17] = false;
	tmplevels[18] = false;
	tmplevels[19] = false;
	j->on = true;
	
	//addmodrigidobject(fn, fnt, sx, sy, fixed, levels, level, lmod, rm, ram, gm, aposx,  aposy);
	//r = addrigidobject("planed.tga", nx, ny, false, tmplevels, 7, 0.025, 0.0003, 70, 1.1);

	float aposx[100][100];
	float aposy[100][100];
	float amass[100][100];

	setupmass(amass);

	for(x = 0; x <= 2; x++) {
		for(y = 0; y < 100; y++) {
			amass[x][y] = 0;
		}
	}

	setupgrid(aposx, aposy);

	aposx[1][0] = 3;
	aposx[3][0] = 31;
	aposy[3][0] = 7;
	aposy[4][0] = 5;
	aposx[5][0] = 48;
	aposy[5][0] = 5;
	aposx[6][0] = 55;
	aposy[6][0] = 9;

	aposy[6][1] = 12;

	aposy[1][2] = 13;
	aposy[2][2] = 13;
	aposx[3][2] = 28;

	aposx[2][3] = 26;
	aposy[2][3] = 28;
	aposx[3][3] = 33;
	aposy[3][3] = 28;
	aposy[4][3] = 28;
	aposy[5][3] = 28;
	aposy[6][3] = 28;
	/*
	aposx[1][0] = 9;
	aposy[1][0] = 1;
	//aposx[2][0] = 7;
	aposy[2][0] = 6;
	aposx[3][0] = 28;
	aposy[3][0] = 3;
	aposx[4][0] = 37;
	aposy[4][0] = 5;
	aposy[5][0] = 4;
	aposy[5][1] = 12;
	*/

	//r = addrigidobject("heli.tga", nx, ny, false, tmplevels, 7, 0.1, 0.001, 40, 1.1);
	if(side == FRIEND) r = addmodrigidobject("graphics\\helid.tga", NULL, nx, ny, false, tmplevels, 7, 1.1, 0.025, 0.0003, 35, aposx, aposy, amass);
	else r = addmodrigidobject("graphics\\helide.tga", NULL, nx, ny, false, tmplevels, 7, 1.1, 0.025, 0.0003, 35, aposx, aposy, amass);

	if(side == FRIEND) {
		j->unoc = heliunoc;
		j->occ = heliocc;
		j->firing = helifiring;
		j->exp = heliexp;
		j->damaged = helidamaged;
		j->damagedo = helidamagedo;
		j->damagedf = helidamagedf;
	}
	else {
		j->unoc = heliunoce;
		j->occ = heliocce;
		j->firing = helifiringe;
		j->exp = heliexpe;
		j->damaged = helidamagede;
		j->damagedo = helidamagedoe;
		j->damagedf = helidamagedfe;
	}

	r->pathoffset = 20;	
	r->gmmult = 30;
	r->afric = 0.995;
	//r->gfric = 0.01;
	j->me = r;
	j->myobj = &(objects[numobjects - 1]);
	for(x = 0; x < 100; x++) {
		for(y = 0; y < 100; y++) {
			if(atomstructure[x][y] != NULL) {
				atomstructure[x][y]->damage = &(j->damage);
			}
		}
	}
	j->init();
	j->dovoices();
	if(j == &(helis[numhelis]))
		numhelis++;
	return j;
}

aagun *byaagun(float x, float y) {
	aagun *j;
	int i;

	j = &(aaguns[0]);
	for(i = 0; i < numaaguns; i++) {
		putpixel(bg, j->x, j->y, green);
		putpixel(buf, j->x, j->y, green);
		if(	!j->destroyed && x < j->x + 39 && x > j->x + 19 &&
			y < j->y + 46 && y >= j->y + 31) {
			return j;
		}
		j++;
	}
	return NULL;
}

plane *addplane(float nx, float ny, bool side) {
	plane *j;
	rigidbody *r;
	int x, y;

	j = &(planes[0]);
	while(j->on) j++;
	j->reset();

	ny -= 100;
	settmplevels();
	tmplevels[1] = false;
	tmplevels[3] = false;
	tmplevels[4] = false;
	tmplevels[5] = false;
	tmplevels[7] = false;
	tmplevels[9] = false;
	tmplevels[11] = false;
	tmplevels[12] = false;

	tmplevels[16] = false;
	tmplevels[17] = false;
	tmplevels[18] = false;
	tmplevels[19] = false;

	j->on = true;
	
	//addmodrigidobject(fn, fnt, sx, sy, fixed, levels, level, lmod, rm, ram, gm, aposx,  aposy, NULL);
	//r = addrigidobject("planed.tga", nx, ny, false, tmplevels, 7, 0.025, 0.0003, 70, 1.1);

	float aposx[100][100];
	float aposy[100][100];

	setupgrid(aposx, aposy);

	aposx[1][0] = 9;
	aposy[1][0] = 1;
	//aposx[2][0] = 7;
	aposy[2][0] = 6;
	aposx[3][0] = 28;
	aposy[3][0] = 3;
	aposx[4][0] = 37;
	aposy[4][0] = 5;
	aposy[5][0] = 4;
	aposy[5][1] = 12;
	
	if(side == FRIEND) r = addmodrigidobject("graphics\\planed.tga", NULL, nx, ny, false, tmplevels, 7, 1.1, 0.025, 0.0003, 70, aposx, aposy, NULL);
	else r = addmodrigidobject("graphics\\planede.tga", NULL, nx, ny, false, tmplevels, 7, 1.1, 0.025, 0.0003, 70, aposx, aposy, NULL);

	if(side == FRIEND) {
		j->unoc = planeunoc;
		j->occ = planeocc;
		j->firing = planefiring;
		j->exp = planeexp;
		j->damaged = planedamaged;
		j->damagedo = planedamagedo;
		j->damagedf = planedamagedf;
	}
	else {
		j->unoc = planeunoce;
		j->occ = planeocce;
		j->firing = planefiringe;
		j->exp = planeexpe;
		j->damaged = planedamagede;
		j->damagedo = planedamagedoe;
		j->damagedf = planedamagedfe;
	}
	//r = addrigidobject("planed.tga", nx, ny, false, tmplevels, 7, 0.025, 0.0001, 70, 1.1);

	//11 - 14

	/*
	atom *a;
	float ax, ay;
	int yh;
	yh = 3;
	ax = r->atomlist[14]->x;//(r->atomlist[11]->x + r->atomlist[17]->x) * 0.5;
	ay = r->atomlist[14]->y + yh;
	cleartmplevels();
	a = addatom(ax, ay, tmplevels, 15);
	addlink(a, r->atomlist[11], sqrt(10 * 10 + yh * yh), 35);
	addlink(a, r->atomlist[17], sqrt(10 * 10 + yh * yh), 35);
	//addlink(a, r->atomlist[10], sqrt(5 * 5 + (yh + 10) * (yh + 10)), 35);
	//addlink(a, r->atomlist[16], sqrt(5 * 5 + (yh + 10) * (yh + 10)), 35);
	addlink(a, r->atomlist[14], yh, 35);
	addlink(a, r->atomlist[13], yh + 10, 35);
	a->rmdt = 1;
	*/
	atom *a;
	float ax, ay;
	int yh;
	yh = 3;
	ax = r->atomlist[14]->x;//(r->atomlist[11]->x + r->atomlist[17]->x) * 0.5;
	ay = r->atomlist[14]->y + yh;
	cleartmplevels();
	a = addatom(ax, ay, tmplevels, 0);
	r->addatom(a);
	r->complete();
	
	yh = 1;
	ax = r->atomlist[5]->x;//(r->atomlist[11]->x + r->atomlist[17]->x) * 0.5;
	ay = r->atomlist[5]->y + yh;
	cleartmplevels();
	a = addatom(ax, ay, tmplevels, 0);
	r->addatom(a);
	r->complete();
	r->pathoffset = 20;	

	r->afric = FLUIDFRICTION;
	r->afric = 0.995;
	j->me = r;
	j->myobj = &(objects[numobjects - 1]);
	for(x = 0; x < 100; x++) {
		for(y = 0; y < 100; y++) {
			if(atomstructure[x][y] != NULL) {
				atomstructure[x][y]->damage = &(j->damage);
			}
		}
	}
	j->init();
	j->dovoices();
	if(j == &(planes[numplanes]))
		numplanes++;
	return j;
}

void updatehelis() {
	heli *j;
	int i;
	j = &(helis[0]);
	for(i = 0; i < numhelis; i++) {
		j->update();
		j++;
	}
}

void drawhelis() {
	heli *j;
	int i;
	j = &(helis[0]);
	for(i = 0; i < numhelis; i++) {
		j->draw();
		j++;
	}
}

void erasehelis() {
	heli *j;
	int i;
	j = &(helis[0]);
	for(i = 0; i < numhelis; i++) {
		j->erase();
		j++;
	}
}

void updateplanes() {
	plane *j;
	int i;
	j = &(planes[0]);
	for(i = 0; i < numplanes; i++) {
		j->update();
		j++;
	}
}

void drawplanes() {
	plane *j;
	int i;
	j = &(planes[0]);
	for(i = 0; i < numplanes; i++) {
		j->draw();
		j++;
	}
}

void eraseplanes() {
	plane *j;
	int i;
	j = &(planes[0]);
	for(i = 0; i < numplanes; i++) {
		j->erase();
		j++;
	}
}

plane *byplane(float x, float y) {
	plane *j;
	int i;

	j = &(planes[0]);
	for(i = 0; i < numplanes; i++) {
		if(	!j->destroyed && j->me != NULL && x < j->me->x + 8 && x > j->me->x - 8 &&
			y < j->me->y + 15 && y >= j->me->y) {
			return j;
		}
		j++;
	}
	return NULL;
}

typedef struct compsoldier compsoldier;

struct soldier {
	atom *me;
	atom *abody;
	/*
	ABITMAP *bodyl;
	ABITMAP *bodyr;
	ABITMAP *body;
	ABITMAP *arm;
	ABITMAP *armbuf;
	ABITMAP *head;
	ABITMAP *headbuf;
	ABITMAP *transbuf;
	*/
	compsoldier *controller;

	bool *keyleft;
	bool *keyright;
	bool *keyup;
	bool *keydown;
	bool *keygetin;

	float force;
	float strength;
	float jumpstrength;
	float bulletforce;
	int firedelay;

	float angle, fangle;
	float tmp1, tmp2;
	int offx, offy, bodyw, bodyh;
	bool direction;
	bool tmp;
	bool invehicle;
	bool gotin;
	bool *fire;
	int fired;
	float tx, ty;
	bool comp;
	bool side;
	bool drew;
	float damage;
	float health;
	bool dead;
	int gunvoice;
	jeep *injeep;
	tank *intank;
	plane *inplane;
	aagun *inaagun;
	heli *inheli;
	int walkframe;
	
	float gunramp;
	float gunrampdir;

	bool firing;

	soldier() {
		reset();
	}

	void reset() {
		controller = NULL;
		keyleft = &(keys['A']);
		keyright = &(keys['D']);
		keyup = &(keys['W']);
		keydown = &(keys['S']);
		keygetin = &(keys[VK_SPACE]);

		gunramp = 0;
		gunrampdir = 0;

		force = 1.7;
		strength = .015;
		jumpstrength = 0.5;
		bulletforce = 3;
		me = NULL;
		firing = false;

		offx = offy = 0;
		direction = RIGHT;
		angle = 0;
		firedelay = 45;
		fired = 0;
		invehicle = false;
		gotin = false;
		comp = false;
		fire = false;
		dead = true;

		tx = ty = 0;
		health = 100;
		gunvoice = -1;
		damage = 0;
		drew = false;
		injeep = NULL;
		intank = NULL;
		inheli = NULL;
		inplane = NULL;
		inaagun = NULL;
		walkframe = 0;
	}

	void killvoices() {
		if(gunvoice != NULL) deallocate_voice(gunvoice);
		gunvoice = NULL;
	}

	void dovoices() {
		if(gunvoice != NULL) deallocate_voice(gunvoice);
		gunvoice = allocate_voice(mgun);
		voice_set_playmode(gunvoice, PLAYMODE_LOOP);
		voice_set_volume(gunvoice, 255);
		//play_sample(mgun, 255, 122, 1000, 0);
		//voice_set_frequency(gunvoice, 8000);
		voice_stop(gunvoice);
	}

	void init(atom *newme, bool newside) {
		me = newme;
		me->draw = false;
		me->damage = &damage;
		side = newside;

		abody = addatom(me->x, me->y - 12, me->levels, me->level);
		abody->draw = false;
		abody->levels[2] = false;
		abody->damage = &damage;
		dovoices();
	}

	void draw() {
		//if(dead) return;
		if(invehicle || dead) return;
		if(me->x + 5 > lx && me->x - 5 < rx) {

			if(!comp) {
				angle = atan2(my - me->y + 8, mx - me->x);
			}
			else {
				angle = atan2(ty - me->y + 8, tx - me->x);
			}

			fangle = angle * convk;
			
			if(fangle < -64 || fangle > 64) {
				direction = LEFT;
				fangle = 128 - fangle;
				if(fangle > 128) fangle -= 256;
			}
			else {
				direction = RIGHT;
			}

			//if(angle < 128 && angle > 64) angle = 64;
			//else if(angle < 200) angle = 200;
			if(fangle > 50) fangle = 50;
			if(fangle < -64) fangle = -64;

			//draw_sprite(transbuf, body, 10, 9);
			if(side == FRIEND) {
				if(direction == RIGHT)
					gldrawsprite(me->x - 10, me->y + 7, soldierbody[walkframe]);
				else
					gldrawspritehflip(me->x + 10, me->y + 7, soldierbody[walkframe]);
			}
			else {
				if(direction == RIGHT)
					gldrawsprite(me->x - 10, me->y + 7, soldierbodye[walkframe]);
				else
					gldrawspritehflip(me->x + 10, me->y + 7, soldierbodye[walkframe]);
			}

			if(direction == LEFT) fangle = -fangle;
			float rot = fangle * convk3;

			glEnable(GL_TEXTURE_2D);

			glPushMatrix();
			
			if(direction == RIGHT)
				glTranslatef(me->x - 0, me->y - 8, 0);
			else
				glTranslatef(me->x - 0, me->y - 8, 0);

			glRotatef(rot,0,0,1);
			//12x7
			if(side == FRIEND)
				glBindTexture(GL_TEXTURE_2D, soldierarm->texID);
			else
				glBindTexture(GL_TEXTURE_2D, soldierarme->texID);

			if(direction == RIGHT) {
				glBegin(GL_QUADS);
					glTexCoord2f(0, 0); glVertex2f(-3, 4);
					glTexCoord2f(0, 1); glVertex2f(-3, -2);
					glTexCoord2f(1, 1); glVertex2f(9, -2);
					glTexCoord2f(1, 0); glVertex2f(9, 4);
				glEnd();
			}
			else {
				glBegin(GL_QUADS);
					glTexCoord2f(0, 0); glVertex2f(3, 4);
					glTexCoord2f(0, 1); glVertex2f(3, -2);
					glTexCoord2f(1, 1); glVertex2f(-9, -2);
					glTexCoord2f(1, 0); glVertex2f(-9, 4);
				glEnd();
			}
				
			glPopMatrix();

			
			glPushMatrix();

			if(direction == RIGHT)
				glTranslatef(me->x - 1, me->y - 11, 0);
			else
				glTranslatef(me->x + 1, me->y - 11, 0);

			glRotatef(rot,0,0,1);			
			if(side == FRIEND)
				glBindTexture(GL_TEXTURE_2D, soldierhead->texID);
			else
				glBindTexture(GL_TEXTURE_2D, soldierheade->texID);

			if(direction == RIGHT) {
				glBegin(GL_QUADS);
					glTexCoord2f(0, 0); glVertex2f(-4, 0);
					glTexCoord2f(0, 1); glVertex2f(-4, -9);
					glTexCoord2f(1, 1); glVertex2f(4, -9);
					glTexCoord2f(1, 0); glVertex2f(4, 0);
				glEnd();
			}
			else {
				glBegin(GL_QUADS);
					glTexCoord2f(0, 0); glVertex2f(4, 0);
					glTexCoord2f(0, 1); glVertex2f(4, -9);
					glTexCoord2f(1, 1); glVertex2f(-4, -9);
					glTexCoord2f(1, 0); glVertex2f(-4, 0);
				glEnd();
			}

			glPopMatrix();

			glDisable(GL_TEXTURE_2D);


			/*
			blit(body, transbuf, walkframe * 19, 0, 5, 9, 19, 19);
			pivot_sprite(armbuf, arm, 15, 13, 3, 2, ((int)fangle));
			pivot_sprite(headbuf, head, 9, 9, 4, 7, ((int)fangle));
			draw_sprite(transbuf, armbuf, 0, 0);
			draw_sprite(transbuf, headbuf, 5, 0);
			if(direction == RIGHT)
				draw_sprite(buf, transbuf, me->x + offx, me->y + offy);
			else
				draw_sprite_h_flip(buf, transbuf, me->x + offx, me->y + offy);
				*/
			drew = true;
		}
	}

	void erase() {
		if(!drew) return;
		if(invehicle || dead) return;
		blit(bg, buf, me->x + offx, me->y + offy, me->x + offx, me->y + offy, bodyw, bodyh);
		drew = false;
	}

	void dokeys() {
		if(dead) return;

		float appstrength;
		float cx, cy, cd;

		cx = me->ix - me->oix;
		cy = me->iy - me->oiy;

		cy -= GRAVITY;
		cd = sqrt(cx * cx + cy * cy);
		cd = fabs(cd);
		//if(cd > 1) {
			//health -= (cd - 1);
		//}
		
		if(comp)
			health -= 20 * damage;
		else
			health -= 5 * damage;
		damage = 0;

		if(health <= 0 || me->y > waterlevel) {
			health = 0;
			dead = true;
			dopanvol(me->x, 0.2);
			play_sample(death1, vol, pan, 1000, 0);
			deallocate_voice(gunvoice);
			voice_ramp_volume(gunvoice, 50, 0);
			gunramp = 0;
			gunrampdir = -0.1;
			gunvoice = NULL;
			if(invehicle) {
				if(injeep != NULL) injeep->getin(this);
				if(intank != NULL) intank->getin(this);
				if(inheli != NULL) inheli->getin(this);
				if(inplane != NULL) inplane->getin(this);
				if(inaagun != NULL) inaagun->getin(this);
			}
			cleartmplevels();
			//tmplevels[8] = true;
			if(side == ENEMY) {
				if(direction == RIGHT)
					addobject("graphics\\soldierder.tga", NULL, me->x - 20, me->y - 27, 0, tmplevels, 8, 1000);
				else
					addobject("graphics\\soldierdel.tga", NULL, me->x - 20, me->y - 27, 0, tmplevels, 8, 1000);
			}
			else {
				if(direction == RIGHT)
					addobject("graphics\\soldierdr.tga", NULL, me->x - 20, me->y - 27, 0, tmplevels, 8, 1000);
				else
					addobject("graphics\\soldierdl.tga", NULL, me->x - 20, me->y - 27, 0, tmplevels, 8, 1000);
			}
			atomstructure[1][0]->ix = me->ix * 0.4;
			atomstructure[2][0]->ix = me->ix * 0.4;
			atomstructure[1][1]->ix = me->ix * 0.2;
			atomstructure[2][1]->ix = me->ix * 0.2;
			if(me->y < waterlevel) {
				atomstructure[1][0]->iy = me->ix * 0.2 - 1;
				atomstructure[2][0]->iy = me->ix * 0.2 - 1;
				atomstructure[1][1]->iy = me->ix * 0.1 - 1;
				atomstructure[2][1]->iy = me->ix * 0.1 - 1;
			}
			else {
				atomstructure[1][0]->iy = me->iy * 0.2;
				atomstructure[2][0]->iy = me->iy * 0.2;
				atomstructure[1][1]->iy = me->iy * 0.1;
				atomstructure[2][1]->iy = me->iy * 0.1;
			}
			if((atomstructure[1][0]->ix > -0.2 && atomstructure[1][0]->ix < 0.2)) {// || (atomstructure[1][0]->ix < -1 || atomstructure[1][0]->ix > 1)) {
				if(direction == RIGHT) {
					atomstructure[1][0]->ix = -.4;
					atomstructure[2][0]->ix = -.4;
					atomstructure[1][1]->ix = -.2;
					atomstructure[2][1]->ix = -.2;
				}
				else {
					atomstructure[1][0]->ix = .4;
					atomstructure[2][0]->ix = .4;
					atomstructure[1][1]->ix = .2;
					atomstructure[2][1]->ix = .2;
				}
			}
			erase();
			if(me != center)
				destroyatom(me);
			else {
				center->rmdt = 0.00001;
				center->fixed = true;
				center->level = 0;
				for(int i = 0; i < MAXLEVELS; i++) {
					center->levels[i] = false;
				}
			}
			destroyatom(abody);
			me = NULL;
			abody = NULL;
			return;
		}

		appstrength = strength * COMPFRAMES;


		if(!gotin && injeep == NULL && inplane == NULL && intank == NULL && inaagun == NULL && inheli == NULL && *keygetin) {//!jeep1.destroyed 
			injeep = byjeep(me->x, me->y);
			if(injeep != NULL) {
				invehicle = true;
				injeep->getin(this);
				gotin = true;
			}
			else {				
				inaagun = byaagun(me->x, me->y);
				if(inaagun != NULL) {
					invehicle = true;
					inaagun->getin(this);
					gotin = true;
				}
				else {
					inplane = byplane(me->x, me->y);
					if(inplane != NULL) {
						invehicle = true;
						inplane->getin(this);
						gotin = true;
					}
					else {
						intank = bytank(me->x, me->y);
						if(intank != NULL) {
							invehicle = true;
							intank->getin(this);
							gotin = true;
						}
						else {
							inheli = byheli(me->x, me->y);
							if(inheli != NULL) {
								invehicle = true;
								inheli->getin(this);
								gotin = true;
							}
						}
					}
				}
			}
			
			/*&& *keygetin && 
			me->x < jeep1.me->x + 8 && me->x > jeep1.me->x - 8 &&

			me->y < jeep1.me->y + 15 && me->y >= jeep1.me->y			
			) {
			invehicle = !invehicle;
			jeep1.getin(this);
			gotin = true;
			*/
		}
		else if(!gotin && injeep != NULL && *keygetin) {
			injeep->getin(this);
			invehicle = false;
			gotin = true;
			injeep = NULL;
		}
		else if(!gotin && inplane != NULL && *keygetin) {
			inplane->getin(this);
			invehicle = false;
			gotin = true;
			inplane = NULL;
		}
		else if(!gotin && inaagun != NULL && *keygetin) {
			inaagun->getin(this);
			invehicle = false;
			gotin = true;
			inaagun = NULL;
		}
		else if(!gotin && intank != NULL && *keygetin) {
			intank->getin(this);
			invehicle = false;
			gotin = true;
			intank = NULL;
		}
		else if(!gotin && inheli != NULL && *keygetin) {
			inheli->getin(this);
			invehicle = false;
			gotin = true;
			inheli = NULL;
		}
		else if(!*keygetin) {
			gotin = false;
		}

		if(invehicle) return;

		/*
		if(dispframe && (*keyleft ||*keyright)) {
			walkframe++;
			if(walkframe >= 8) walkframe = 0;
		}
		*/

		if(dispframe) {
			if((*keyleft || *keyright) && me->y > path[(int)(me->x)] - 9) {
				walkframe++;
			}
			else {
				walkframe = 0;
			}
			if(walkframe >= 8) walkframe = 0;
		}

		if(me->y > path[(int)(me->x)] - 6) {
			if(*keyleft && !*keyright) {
				if(me->ix > -force + appstrength) {
					me->ix -= appstrength;
				}
				else if(me->ix > -force) {
					me->ix = -force;
				}
			}
			else if(*keyright && !*keyleft) {
				if(me->ix < force - appstrength) {
					me->ix += appstrength;
				}
				else if(me->ix < force) {
					me->ix = force;
				}
			}
			else {
				if(me->ix < -appstrength) {
					me->ix += appstrength;
				}
				else if(me->ix > appstrength) {
					me->ix -= appstrength;
				}
				else {
					me->ix = 0;
				}
			}

			if(*keyup) {
				me->iy -= jumpstrength * COMPFRAMES;
				if(*keyleft && !*keyright && me->ix > -15 * appstrength) {
					me->ix -=  3 * appstrength;
				}
				else if(*keyright && !*keyleft && me->ix < 15 * appstrength) {
					me->ix += 3 * appstrength;
				}
			}
		}

		if(((!comp && lmb) || (comp && *fire)) && fired <= 0) {
			if(voice_check(gunvoice) != mgun) dovoices();
			gunrampdir = 0.1;
			voice_set_playmode(gunvoice, PLAYMODE_LOOP);
			firing = true;
			tmp1 = cos(angle);
			tmp2 = sin(angle);
			addbullet(me->x + 13 * tmp1, me->y - 8 + 13 * tmp2, bulletforce * tmp1, bulletforce * tmp2, side, 100, 1, 0.3, gray, false);
			fired = firedelay;
			voice_start(gunvoice);
		}
		if(fired > -10) fired--;
		if(fired < -5) {
			voice_ramp_volume(gunvoice, 50, 0);
			firing = false;
			//voice_set_playmode(gunvoice, 0);//, PLAYMODE_BACKWARD);
			//if(voice_get_position(gunvoice) <= 10) voice_stop(gunvoice);
			//voice_set_position(gunvoice, 0);
		}
	}

	void update() {
		if(dead) return;

		if(gunrampdir > 0) {
			gunramp += gunrampdir;
			if(gunramp >= 1) {
				gunrampdir = 0;
				gunramp = 1;
			}
		}
		else if(gunrampdir < 0) {
			gunramp += gunrampdir;
			if(gunramp <= 0) {
				gunrampdir = 0;
				gunramp = 0;
			}
		}

		if(firing) {
			dopanvol(me->x, 0.3);
			voice_set_pan(gunvoice, pan);
			voice_set_volume(gunvoice, vol * gunramp);
		}

		if(invehicle) {
			if(injeep != NULL) {
				me->x = injeep->me->x;
				me->y = injeep->me->y;
				me->ix = injeep->me->ix * 0.1;
				me->iy = injeep->me->iy * 0.1;
			}
			else if(intank != NULL) {
				me->x = intank->me->x;
				me->y = intank->me->y;
				me->ix = intank->me->ix * 0.0;
				me->iy = intank->me->iy * 0.0;
			}
			else if(inplane != NULL) {
				me->x = inplane->me->x;
				me->y = inplane->me->y;
				me->ix = 0;
				me->iy = 0;
			}
			else if(inheli != NULL) {
				me->x = inheli->me->x;
				me->y = inheli->me->y;
				me->ix = 0;
				me->iy = 0;
			}
			else if(inaagun != NULL) {
				me->x = inaagun->x + 29;
				me->y = inaagun->y + 36;
				me->ix = 0;
				me->iy = 0;
			}
			abody->x = me->x;
			abody->y = me->y - 12;
			abody->ix = 0;
			abody->iy = 0;
		}
		else {
			me->ix += abody->ix;
			abody->ix = 0;
			abody->iy = 0;
			abody->x = me->x;
			abody->y = me->y - 12;
		}
		dokeys();
	}
};

soldier soldiers[MAXSOLDIERS];
int numsoldiers;
soldier *human;


struct compsoldier {
	soldier *me;

	bool goleft;
	bool goright;
	bool goup;
	bool godown;
	bool getin;
	bool fire;
	bool dropbomb;
	float personality;
	bool side;
	
	//BEHAVIORS:

	//Script
	bool script;
	movie *myscript;
	int myactorno;
	int frameoff;

	//Hunt
	bool hunt;

	//Patrol
	bool patrol;
	int patrolzonel;
	int patrolzoner;
	bool patroldirection;

	//Trippatrol (Patrols until sights enemy)
	bool trippatrol;

	//Wait
	bool wait;

	//			**AAGUN**
	//Aagunner
	bool aagunner;
	aagun *mygun;

	//			**TANK**
	//Tankdriver
	bool tankdriver;
	bool intank;
	tank *mytank;

	//			**AIRPLANE**
	//Planepilot
	bool planepilot;
	bool inplane;
	float cruisealt;
	float planeoffdist;
	plane *myplane;
	
	//Takeoff
	bool takeoff;

	//Startrun
	bool startrun;

	//Inrun
	bool inrun;

	//Planehunt

	//Flyto
	bool flyto;
	float dest;
	bool *action;

	compsoldier() {
		reset();
	}

	void reset() {
		me = NULL;
		goleft = goright = goup = godown = getin = fire = dropbomb = false;
		fire = false;
		script = patrol = hunt = startrun = inrun = flyto = tankdriver = planepilot = false;
		mytank = NULL;
		myplane = NULL;
		action = NULL;
		intank = false;
		inplane = false;
		trippatrol = false;
		wait = false;
		side = ENEMY;
		side = FRIEND;
		cruisealt = 100;
		takeoff = false;
		personality = (rand() % 100) / 100.0;
		planeoffdist = 500;
		me = NULL;
		side = ENEMY;
	}

	void init(soldier *s, bool newside) {
		personality = (rand() % 100) / 100.0;
		me = s;
		me->keyleft = &goleft;
		me->keyright = &goright;
		me->keyup = &goup;
		me->keydown = &godown;
		me->keygetin = &getin;
		me->fire = &fire;
		me->comp = true;
		me->invehicle = false;
		me->controller = this;
		goleft = goright = goup = godown = getin = fire = dropbomb = false;
		side = newside;
	}

	void doscript(movie *newscript, int newactorno, int newframeoff) {
		script = true;
		myscript = newscript;
		myactorno = newactorno;
		frameoff = newframeoff;
		patrol = hunt = startrun = inrun = flyto = tankdriver = planepilot = false;
	}

	void dohunt() {
		hunt = true;
	}

	void dopatrol(int l, int r) {
		hunt = false;
		patrol = true;
		patrolzonel = l;
		patrolzoner = r;
		patroldirection = RIGHT;
	}

	void dotrippatrol(int l, int r) {
		hunt = false;
		patrol = true;
		trippatrol = true;
		patrolzonel = l;
		patrolzoner = r;
		patroldirection = RIGHT;
	}

	void dowait() {
		wait = true;
		hunt = false;
	}

	void doaagunner(aagun *a) {
		mygun = a;
		aagunner = true;
	}

	void dotankdriver(tank *t) {
		mytank = t;
		tankdriver = true;
		intank = false;
	}

	void doplanepilot(plane *p) {
		myplane = p;
		planepilot = true;
		inplane = false;
	}

	void doflyto(float newdest, bool *newaction) {
		flyto = true;
		dest = newdest;
		action = newaction;
	}

	void update() {
		if(me == NULL) return;
		if(me->dead) {
			me = NULL;
			return;
		}

		goleft = goright = goup = godown = getin = fire = dropbomb = false;

		if(script) {
			if(frame + frameoff > myscript->lastframe) {
				script = false;
				//exit(0);
			}
			else {
				int tmx, tmy;
				tmx = tmy = 0;
				tmpkeys = 0;
				goleft = goright = goup = godown = getin = fire = dropbomb = false;
				movie_getkeys(myscript, myactorno, frame + frameoff, tmpkeys, tmx, tmy);
				me->tx = tmx;
				me->ty = tmy;
				if(tmpkeys & M_W)
					goup = true;
				if(tmpkeys & M_S)
					godown = true;
				if(tmpkeys & M_A)
					goleft = true;
				if(tmpkeys & M_D)
					goright = true;
				if(tmpkeys & M_MOUSE1)
					fire = true;
				if(tmpkeys & M_MOUSE2)
					dropbomb = true;
				if(tmpkeys & M_SPACE) {
					getin = true;
				}
				if(me->invehicle && me->intank != NULL) {
					me->intank->tx = tmx;
					me->intank->ty = tmy;
				}
				if(me->invehicle && me->inplane != NULL) {
					me->inplane->tx = tmx;
					me->inplane->ty = tmy;
				}
				if(me->invehicle && me->inheli != NULL) {
					me->inheli->tx = tmx;
					me->inheli->ty = tmy;
				}
				return;
			}
		}

		if(drawframe % 100 == 0)		
			personality = (rand() % 100) / 100.0;

		/*
		if(human->dead) {
			goleft = goright = goup = godown = fire = false;
			me->dokeys();
			return;
		}
		*/

		float tx, ty;
		float ex, ey;
		float eix, eiy;
		float x, y;
		int i;
		bool edead;
		float closest;
		soldier *s, *cs;
		x = me->me->x;
		y = me->me->y;
		closest = 100000;

		ex = 1000;
		ey = 400;
		eix = eiy = 0;
		edead = true;

		cs = NULL;
		if(side == ENEMY) {
			s = &(soldiers[0]);
			for(i = 0; i < numsoldiers; i++) {
				if(s->side == FRIEND && !s->dead) {
					if(fabs(x - s->me->x) < closest) {
						cs = s;
						closest = fabs(x - s->me->x);
					}
				}
				s++;
			}
		}
		else if(side == FRIEND) {
			s = &(soldiers[0]);
			for(i = 0; i < numsoldiers; i++) {
				if(s->side == ENEMY && !s->dead) {
					if(fabs(x - s->me->x) < closest) {
						cs = s;
						closest = fabs(x - s->me->x);
					}
				}
				s++;
			}
		}
		if(cs != NULL) {
			ex = cs->me->x;
			ey = cs->me->y;
			eix = cs->me->ix;
			eiy = cs->me->iy;
		}
		edead = false;

		if(hunt && !inplane) {
			int offdist;
			bool missing = false;
			tx = ex;
			if(intank) ty = ey - fabs(x - ex) * 0.15;
			else ty = ey - 8;
			if(intank) offdist = 250;
			else offdist = 50;
			offdist = (0.5 + 1.5 * personality) * offdist;
			if(intank && (mytank->goalang == -128 || mytank->goalang == 0)) {
				offdist = 10;
				missing = true;
			}

			if(!(tankdriver && !intank)) {
				if(me->tx < me->me->x - offdist) {
					goleft = true;
					goright = false;
					if(patrol) patroldirection = LEFT;
				}
				else if(me->tx > me->me->x + offdist) {
					goright = true;
					goleft = false;
					if(patrol) patroldirection = RIGHT;
				}
				else {
					goleft = goright = false;
				}
			}
			if((fabs(tx - x) <= offdist + 20 || (!missing && fabs(tx - x) < 200 + 200 * personality)) && (!intank || mytank->fired <= 0)) {
				if(intank) ty += 60 * (rand() % 100) * 0.01 - 30;
				else ty += 30 * (rand() % 100) * 0.01 - 15;
				fire = true;
			}
			else fire = false;
		}
		else {
			fprintf(debug, "NOT HUNT!!!\n");
		}
		if(patrol) {
			if(abs(x - ex) < 200) {
				hunt = true;
				if(trippatrol) {
					patrol = false;
					trippatrol = false;
				}
			}
			else if(abs(x - ex) > 300) hunt = false;

			if(x >= patrolzoner) {
				patroldirection = LEFT;
				goright = false;
			}
			else if(x <= patrolzonel) {
				patroldirection = RIGHT;
				goleft = false;
			}
			if(!hunt && patroldirection == RIGHT) {
				goright = true;
				goleft = false;
				if(intank) {
					tx = x + 5;
					ty = y;
				}
				else {
					tx = x + 5;
					ty = y - 8;
				}
				fire = false;
			}
			else if(!hunt && patroldirection == LEFT) {
				goleft = true;
				goright = false;
				if(intank) {
					tx = x - 5;
					ty = y;
				}
				else {
					tx = x - 5;
					ty = y - 8;
				}
				fire = false;
			}
		}
		if(wait) {			
			if(abs(x - ex) < 600) {
				hunt = true;
				wait = false;
			}
		}
		if(aagunner && !edead) {
			if(!me->invehicle) {
				if(mygun->x  + 26 < x - 5)
					goleft = true;
				else if(mygun->x + 26> x + 5)
					goright = true;
				else {
					mygun->getin(me);
					me->invehicle = true;
					me->inaagun = mygun;
					mygun->fire = &fire;
				}
			}
			else {
				float dx, dy, dist;
				dx = ex - x;
				dy = ey - y;
				dy *= 1;
				if(dx > 500) dx = 500;
				else if(dx < -500) dx = -500;
				dist = (dx * dx + dy * dy);
				if(eix > 0) {
					mygun->tx = ex + 0.0008 * dist;
					//mygun->tx = ex + 0.85 * fabs(y - ey) + 0.0005 * fabs(x - ex) * fabs(y - ey);
				}
				else {
					mygun->tx = ex - 0.0008 * dist;
					//mygun->tx = ex - 0.85 * fabs(y - ey) - 0.0005 * fabs(x - ex) * fabs(y - ey);
				}
				mygun->ty = ey;
				//mygun->ty += 0.5 * dist;

				//mygun->ty = ey + 15 * eiy;
				if(fabs(x - ex) < 500 && fabs(mygun->fangle - mygun->angle) < 1) {
					fire = true;
				}
			}
		}
		if(tankdriver) {
			if(mytank->destroyed) {
				tankdriver = false;
				hunt = true;
				intank = false;
			}
			else {
				if(!me->invehicle) {
					intank = false;
					if(mytank->x < x - 5) {
						goleft = true;
					}
					else if(mytank->x > x + 5) {
						goright = true;
					}
					else if(!mytank->occupied) {
						mytank->getin(me);
						me->invehicle = true;
						me->intank = mytank;
						mytank->fire = &fire;
						mytank->keyleft = &goleft;
						mytank->keyright = &goright;
						mytank->keyup = &goup;
						mytank->keydown = &godown;
						intank = true;
					}
				}
				else {					
					mytank->tx = tx;
					mytank->ty = ty;
				}
			}
		}		
		if(planepilot) {
			float px, py, pix, piy;
			if(myplane->destroyed) {
				planepilot = false;
				hunt = true;
				inplane = false;
			}
			else {
				px = myplane->me->x;
				py = myplane->me->y - 0;
				pix = myplane->me->ix;
				piy = myplane->me->iy;
				goleft = goright = goup = godown = fire = dropbomb = false;
				if(!me->invehicle) {
					inplane = false;
					if(px < x - 5) {
						goleft = true;
					}
					else if(px > x + 5) {
						goright = true;
					}
					else if(!myplane->occupied) {
						myplane->getin(me);
						me->invehicle = true;
						me->inplane = myplane;
						myplane->fire = &fire;
						myplane->dropbomb = &dropbomb;
						myplane->keyleft = &goleft;
						myplane->keyright = &goright;
						myplane->keyup = &goup;
						myplane->keydown = &godown;
						inplane = true;
						takeoff = true;
					}
				}
				else {
					//textprintf(buf, font, screencenterx - 300, 70, white, "%i,%i,%i,%i", takeoff, flyto, startrun, inrun);

					float cutoff = 0.00000001 * py * py * py * py;
					float ta;
					float gy;
					gy = path[(int)px];
					ta = myplane->me->ang * convk - 64;
					if(myplane->direction == LEFT) ta += 128;
					if(ta > 256) ta -= 256;
					if(ta < -64 || ta > 64) ta = 64;
					cutoff += 4.5 * (64 - fabs(ta));
					if(myplane->direction == LEFT) {
						cutoff = findlow(gy, path[(int)(px - 50)], path[(int)(px + 5 * pix)]) - cutoff;
					}
					else {
						cutoff = findlow(gy, path[(int)(px + 50)], path[(int)(px + 5 * pix)]) - cutoff;
					}


					if(py < ey && py < gy - 50 && fabs((px + pix*myplane->me->rm*(ey-py)*0.8) - ex) < 20) {
						dropbomb = true;
					}

					if(takeoff) {
						goup = true;
						if(px > buf->w - 200)
							goleft = true;
						else if(px < 200)
							goright = true;
						if(py > gy - 50) {
							if(myplane->direction == RIGHT) {
								tx = px + 10;
								ty = py - 2;
							}
							else {
								tx = px - 10;
								ty = py - 2;
							}
						}						
						else if(py > cruisealt) {
							if(myplane->direction == RIGHT) {
								tx = px + 10;
								ty = py - 6;
							}
							else {
								tx = px - 10;
								ty = py - 6;
							}
						}
						else {
							takeoff = false;
							if(flyto == false) startrun = true;
							//startrun = true;
							//doflyto(2000, &hunt);
						}
					}
					else if(py > gy - 50 && 0) {
						inrun = false;
						startrun = false;
						flyto = false;
						takeoff = true;
					}
					else if(piy > 0 && py > cutoff) {
						inrun = false;
						startrun = true;
						flyto = false;
						takeoff = false;
					}
					if(startrun) {
						if(fabs(ex - px) < planeoffdist) {
							if(myplane->direction == LEFT) 
								doflyto(ex - planeoffdist, &startrun);
							else
								doflyto(ex + planeoffdist, &startrun);
							startrun = false;
						}
						else {
							if(ex < px) {
								goleft = true;
							}
							else {
								goright = true;
							}
							startrun = false;
							inrun = true;
						}
					}
					if(flyto) {
						tx = dest;
						ty = cruisealt - 50;
						if(myplane->direction == LEFT) tx -= 100;
						else tx += 100;
						if(px > buf->w - 200) {
							goleft = true;
							flyto = false;
							startrun = true;
						}
						else if(px < 200) {
							goright = true;
							flyto = false;
							startrun = true;
						}
						else {
							if(tx < px)
								goleft = true;
							else
								goright = true;
							if(fabs(dest - px) < 100) {
								flyto = false;
								*action = true;
							}
						}
					}
					if(inrun) {
						int offdist = 500;
						float dx, dy, dist;
						dx = px - ex;
						dy = py - ey;
						dist = sqrt(dx * dx + dy * dy);
						tx = ex + eix * dist * 0.08;
						ty = ey - 5;
						if((tx < px && myplane->direction == RIGHT) || (tx > px && myplane->direction == LEFT)) {
							takeoff = true;
							hunt = false;
						}
						if(fabs(tx - x) <= offdist) {
							fire = true;
							tx += rand() % 60 - 30;
						}
						else fire = false;
					}
					myplane->tx = tx;
					myplane->ty = ty;
				}
			}
		}

		me->tx = tx;
		me->ty = ty;
	}
};

compsoldier compsoldiers[MAXCOMPSOLDIERS];
int numcompsoldiers;

void aagun::update() {
	float dx, dy;
	int tmpv;
	bullet *b;

	if(occupied) {
		float goalangle;
		
		if(!driver->comp) {
			if(direction == RIGHT) {
				goalangle = atan2(my + 3 - (y + 30), mx - (x + 30));
			}
			else {
				goalangle = atan2(my + 3 - (y + 30), mx - (x + 36));
			}
		}
		else {
			if(direction == RIGHT) {
				goalangle = atan2(ty + 3 - (y + 30), tx - (x + 30));
			}
			else {
				goalangle = atan2(ty + 3 - (y + 30), tx - (x + 36));
			}
		}
		fangle = goalangle * convk;

		if(direction == RIGHT && angle <= 128) {//(angle < -64 || angle > 64)) {			
			direction = LEFT;
		}
		else if(direction == LEFT && angle > 128) {//(angle < -64 || angle > 64)) {			
			direction = RIGHT;
		}

		fangle += 192;
		if(fangle > 256) fangle -= 256;

		if(fangle < 45) fangle = 45;
		if(fangle > 211) fangle = 211;

		if(angle - speed < fangle) {
			angle += speed;
		}
		else if(angle + speed > fangle) {
			angle -= speed;
		}

		dangle = angle - 192;
		if(direction == LEFT) dangle = 128 - dangle;
		if(dangle < 0) dangle += 256;
	}
	if(occupied || (!occupied && numfired > 0)) {
		if(fired <= 0 && (numfired > 0 || (occupied && driver->comp && *fire) || (occupied && !driver->comp && lmb))) {
			dx = cos((angle + 64) * convk2);
			dy = sin((angle + 64) * convk2);
			//if(voice_check(driver->gunvoice) != mgun) driver->dovoices();
			//voice_ramp_volume(driver->gunvoice, 50, 255);
			//voice_set_playmode(driver->gunvoice, PLAYMODE_LOOP);
			if(direction == RIGHT)
				b = addbullet(x + 29 + 36 * dx, y + 28 + 36 * dy, bulletforce * dx, bulletforce * dy, (occupied && driver->comp), 400, 1, 3, yellow, false);
			else
				b = addbullet(x + 35 + 36 * dx, y + 28 + 36 * dy, bulletforce * dx, bulletforce * dy, (occupied && driver->comp), 400, 1, 3, yellow, false);
			if(b != NULL) {
				b->me->rmdt = 0.1;
				b->me->dmult = 100;
			}
			//myobj->obj = firing;
			//voice_start(driver->gunvoice);
			if(numfired == 0) {
				tmpv = allocate_voice(aagunfire);
				voice_set_priority(tmpv, 255);
				voice_start(tmpv);
				release_voice(tmpv);
			}
			numfired++;
			if(numfired == 6) {
				fired = 200;
				numfired = 0;
			}
			else {
				fired = 35;
			}
		}
		if(fired > -10) fired--;
		/*
		if(fired <= 5 && myobj->obj == firing) {
			if(occupied) myobj->obj = occ;
			else myobj->obj = unoc;
		}
		if(fired < -5) {
			voice_ramp_volume(driver->gunvoice, 50, 0);
		}
		*/
	}
}
	
void aagun::draw() {
	if(x + w > lx && x < rx) {
		clear_to_color(hold, magenta);
		
		/*

		//if(angle < 128 && angle > 64) angle = 64;
		//else if(angle < 200) angle = 200;
		if(fangle > 50) fangle = 50;
		if(fangle < -64) fangle = -64;
		*/

		//draw_sprite(transbuf, barrel, 10, 9);
		//pivot_sprite(barrelbuf, barrel, 15, 13, 3, 2, ((int)fangle));
		draw_sprite(hold, gunbg, offx, offy);
		pivot_sprite(hold, barrel, 22 + offx, 5 + offy, 13, 4, ((int)dangle));
		if(!occupied)
			draw_sprite(hold, base, offx, offy - 1);
		else if(occupied && driver->comp == false)
			draw_sprite(hold, baseo, offx, offy - 1);
		else if(occupied && driver->comp == true)
			draw_sprite(hold, baseoe, offx, offy - 1);
		if(direction == RIGHT) {
			draw_sprite(buf, hold, x, y);
		}
		else {
			draw_sprite_h_flip(buf, hold, x, y);
		}
		drew = true;
	}
}

void jeep::update() {
	int tmpv;

	if(destroyed) return;
	if(occupied) {
		dokeys();
		if(me->ix > 40 || me->ix < -40) me->ix *= 0.9;
		if(me->iy > 0)
			voice_set_frequency(engvoice, (fabs(me->ix) + me->iy) * 100 + 10000);
		else
			voice_set_frequency(engvoice, fabs(me->ix) * 100 + 10000);
		//if(voice_check(engstartvoice) != enginestart) dovoices();
	}
	if(damage > 150) {
		if(occupied) {
			driver->me->iy -= 15;
			driver->me->ix = me->ix * 0.4;
			driver->health -= 50;
			driver->injeep = NULL;
			driver->invehicle = false;
			occupied = false;
		}
		if(direction == LEFT) {
			myobj->obj = expl;
		}
		else if(direction == RIGHT) {
			myobj->obj = exp;
		}
		addanimation(explosionanim, 16, me->x - 32, me->y + 32, true, 0, 1, 0);
		me->y -= 5;
		me->update();
		destroyvehiclerigidbody(me);
		me = NULL;
		destroyed = true;
		tmpv = allocate_voice(explode);
		voice_set_priority(tmpv, 255);
		voice_start(tmpv);
		release_voice(tmpv);
		deallocate_voice(engvoice);
		engvoice = NULL;
	}
}

void tank::getin(soldier *newdriver) {
	atom *a;
	driver = newdriver;
	if(destroyed) return;
	if(occupied == false) {
		occupied = true;
		//driver->me->levels[me->atomlist[0]->level] = false;
		driver->me->dtmult = 0;
		driver->abody->dtmult = 0;
		if(voice_check(engstartvoice) != enginestart) dovoices();
		voice_start(engstartvoice);
		dopanvol(me->x, 0.5);
		voice_set_pan(engstartvoice, pan);
		voice_set_volume(engstartvoice, vol);
		release_voice(engstartvoice);
		engstarted = false;
		voice_set_position(engstartvoice, 0);
		if(driver->side == ENEMY) {
			a = me->atomlist[0];
			for(int i = 0; i < me->mynumatoms; i++) {
				a->levels[1] = true;
				a->levels[5] = false;
				a->levels[14] = false;
				a->level = 12;
				a++;
			}
		}
		else {
			a = me->atomlist[0];
			for(int i = 0; i < me->mynumatoms; i++) {
				a->levels[1] = false;
				a->levels[5] = true;
				a->levels[13] = false;
				a->level = 11;
				a++;
			}			
			keyleft = &(keys['A']);
			keyright = &(keys['D']);
			keyup = &(keys['W']);
			keydown = &(keys['S']);
		}
		//voice_ramp_volume(engvoice, 100, 255);
		/*
		if(direction == RIGHT)
			myobj->obj = occ;
		else
			myobj->obj = occl;
			*/
	}
	else {
		driver->me->dtmult = 1;
		driver->abody->dtmult = 1;
		voice_ramp_volume(engvoice, 100, 0);
		engramp = 0;
		engdir = 0;
		//engdir = -0.03;
		occupied = false;
		engstarted = false;
		a = me->atomlist[0];
		for(int i = 0; i < me->mynumatoms; i++) {
			a->levels[1] = false;
			a->levels[5] = false;
			a->level = 7;
			a++;
		}
		/*
		if(direction == RIGHT)
			myobj->obj = unoc;
		else
			myobj->obj = unocl;
			*/
	}
}
 

void tank::draw() {
	if(destroyed) return;

	float offset;
	float tmp;

	if(firing != 0) {
		if(firing == 20) {
			barrel = tankbarrelanim[0];
			firing = 0;
		}
		else if(firing % 2 == 0) {
			barrel = tankbarrelanim[int(firing * 0.5)];
			firing++;
		}
		else {
			firing++;
		}

		float offset = 18;
		if(firing == 2) {
			int tmpv;
			tmpv = allocate_voice(tankfire);
			voice_set_priority(tmpv, 255);
			voice_start(tmpv);
			dopanvol(me->x, 0.15);
			voice_set_pan(tmpv, pan);
			voice_set_volume(tmpv, vol);
			release_voice(tmpv);
			me->ix -= 500 * cos(barrelang * convk2);
			me->gfric = 0.007;
		}
		if(firing == 6) {
			me->gfric = 0.001;
		}

		if(firing == 10) {
			addanimation(whiteanim, 24, x + offset * ca - 15, y + offset * sa + 15, true, -0.1, 1, 1);
			addanimation(whiteanim, 24, x + offset * ca - 15, y + offset * sa + 15, true, -0.4, 1, 5);
		}
		else if(firing == 11) {
			addanimation(whiteanim, 24, x + offset * ca - 15, y + offset * sa + 15, true, -0.8, 1, 15);
		}
		else if(firing == 12) {
			addanimation(whiteanim, 24, x + offset * ca - 15, y + offset * sa + 15, true, -1.2, 1, 25);
			addanimation(whiteanim, 24, x + offset * ca - 15, y + offset * sa + 15, true, -1.5, 1, 30);
		}
		
		if(firing == 6) {
			
			float bulletforce = 3;
			offset = 0;
			addbomb(x + offset * oca, y + offset * osa, bulletforce * oca, bulletforce * osa, driver->side, shell, BOMB);
			offset -= 4;
			/*
			offset -= 4;
			addanimation(redanim, 24, x + offset * ca - 15, y + offset * sa - 15, true, 0, 1, 5);
			offset += 5;
			addanimation(yellowanim, 24, x + offset * ca - 15, y + offset * sa - 15, true, 0, 1, 15);
			offset += 5;
			addanimation(yellowanim, 24, x + offset * ca - 15, y + offset * sa - 15, true, 0, 1, 25);
			offset -= 15;
			*/
		}

	}

	offset = 6.5;
	tmp = 3 - 0.6 * abs((barrelang + 64) * 0.08);
	if(tmp > 0) offset -= tmp;

	glPushMatrix();
	glBindTexture(GL_TEXTURE_2D, barrel->texID);

	glTranslatef(x + offset * ca - 1, y + offset * sa, 0);
	//fprintf(debug, "angle = %f\n", barrelang + mk);
	glRotatef((barrelang + mk) * convk3, 0, 0, 1);

	glBegin(GL_QUADS);
		glTexCoord2f(0, 0); glVertex2f(0, 4);
		glTexCoord2f(0, 1); glVertex2f(0, -4);
		glTexCoord2f(0.53125, 1); glVertex2f(17, -4);
		glTexCoord2f(0.53125, 0); glVertex2f(17, 4);
	glEnd();

	glPopMatrix();
	//pivot_sprite(buf, barrel, x + offset * ca, y + offset * sa, 0, 4, (barrelang + mk));
}

void tank::dokeys() {
	if(destroyed) return;
	float appstrength;
	float dx, dy, d, dtx, dty;
	//float rx, ry;
	int motors[5] = {2, 6, 10, 14, 17};
	int i;
	atom *a;

	//offset = 0;


	if(!engstarted && voice_get_position(engstartvoice) >= 10000) {
		engdir = 0.02;
		engramp = 0;
		engstarted = true;
	}

	tx = mx;
	ty = my;

	dx = me->atomlist[4]->x - me->atomlist[0]->x;
	dy = me->atomlist[4]->y - me->atomlist[0]->y;
	//rx = -dy;
	//ry = dx;
	d = sqrt(dx * dx + dy * dy);
	dx = dx / d;
	dy = dy / d;

	appstrength = strength * COMPFRAMES;

	dx *= appstrength * 0.05;
	dy *= appstrength * 0.05;

	dtx = tx - me->x;
	dty = ty - me->x;


	speed = sqrt(me->ix * me->ix + me->iy * me->iy);

	for(i = 0; i < 5; i++) {
		a = me->atomlist[motors[i]];
		if(a->y > path[(int)a->x] - 5) {
			//me->ix += dx * 0.05;
			//me->iy += dy * 0.05;
			engspeed = 100;
			if(*keyleft && !*keyright && !*keydown && (speed < engspeed || (dx > 0 && me->ix > 0) || (dx < 0 && me->ix < 0))) {
				me->ix -= dx;
				me->iy -= dy;
			}
			else if(*keyright && !*keyleft && !*keydown && (speed < engspeed || (dx > 0 && me->ix < 0) || (dx < 0 && me->ix > 0))) {
				me->ix += dx;
				me->iy += dy;
			}
			else if(!*keyright && !*keyleft) {
				//me->imult = 0;

				if(me->ix < -dx) me->ix += dx;
				else if(me->ix > dx) me->ix -= dx;
				else {
					me->ix = 0;
				}

				/*
				if(me->iy < -dy) me->iy += dy;
				else if(me->iy > dy) me->iy -= dy;
				else {
					me->iy = 0;
				}
				*/

				me->mx = 0;
				//me->my = 0;
				
				if(a->ix < -dx) a->ix += dx;
				else if(a->ix > dx) a->ix -= dx;
				else {
					a->ix = 0;
				}

				/*
				if(a->iy < -dy) a->iy += dy;
				else if(a->iy > dy) a->iy -= dy;
				else {
					a->iy = 0;
				}
				*/
				
				a->mx = 0;
				//a->my = 0;
			}
			/*
			else {
				dx *= 0.4;
				dy *= 0.4;
				if(me->ix > dx) {
					me->ix -= dx;
					if(me->iy > dy)
						me->iy -= dy;
					else if(me->iy < -dy)
						me->iy += dy;
					else
						me->iy = 0;
				}
				else if(me->ix < -dx) {
					me->ix += dx;
					if(me->iy > dy)
						me->iy -= dy;
					else if(me->iy < -dy)
						me->iy += dy;
					else
						me->iy = 0;
				}
				else {
					me->ix = 0;
					if(me->iy > dy)
						me->iy -= dy;
					else if(me->iy < -dy)
						me->iy += dy;
					else
						me->iy = 0;
				}
			}
			*/
		}
	}

	if(fired <= 0 && ((occupied && !driver->comp && lmb) || (occupied && driver->comp && *fire))) {
		//if(voice_check(driver->gunvoice) != mgun) driver->dovoices();
		//voice_ramp_volume(driver->gunvoice, 50, 255);
		//voice_set_playmode(driver->gunvoice, PLAYMODE_LOOP);
		//if(direction == RIGHT)
		//addbullet(me->x + 28 * dx + 8 * rx, me->y + 28 * dy + 8 * ry, bulletforce * dx + 0.025 * me->ix, bulletforce * dy + 0.025 * me->iy, 0, 150, 1, 1, black);
		//x + offset * ca, y + offset * sa
		//addbomb(me->x + 15 * rx, me->y + 15 * ry, me->ix * 0.025, me->iy * 0.02, 0);
		//addbullet(x + offset * ca, y + offset * sa, bulletforce * ca, bulletforce * sa, 0, 150, 1, 1, black);
		//else
			//addbullet(me->x - 28 * dx + 8 * rx, me->y - 28 * dy + 8 * ry, -bulletforce * dx + 0.025 * me->ix, -bulletforce * dy + 0.025 * me->iy, 0, 150, 1, 1, black);
		//if(!isdamaged) myobj->obj = firing;
		//else myobj->obj = damagedf;
		//voice_start(driver->gunvoice);
		fired = 300;			
		firing = 1;
		oca = ca;
		osa = sa;
	}
	fired--;


	/*
	if(dtx < 0 && barreldirection == RIGHT) {
		barreldirection = LEFT;
		barrelang = -128 - barrelang;
	}
	else if(dtx > 0 && barreldirection == LEFT) {
		barrelang = -128 - barrelang;
		barreldirection = RIGHT;
	}
	*/

		/*
	if(me->y > path[(int)me->x] - 10 || me->y > path[(int)me->x + 10] - 10 || me->y > path[(int)me->x + 10] - 10) {

		if(*keyleft && !*keyright && !*keydown) {
			me->ix -= dx;
			me->iy -= dy;
			if(direction != LEFT) {
				direction = LEFT;
				//myobj->obj = occl;
			}
		}
		else if(*keyright && !*keyleft && !*keydown) {
			me->ix += dx;
			me->iy += dy;
			if(direction != RIGHT) {
				direction = RIGHT;
				//myobj->obj = occ;
			}
		}
		else if(*keydown && !*keyleft && !*keyright) {
			if(direction == LEFT) {
				me->ix += dx;
				me->iy += dy;
			}
			else if(direction == RIGHT) {
				me->ix -= dx;
				me->iy -= dy;
			}
		}
		else {
			dx *= 0.4;
			dy *= 0.4;
			if(me->ix > dx) {
				me->ix -= dx;
				if(me->iy > dy)
					me->iy -= dy;
				else if(me->iy < -dy)
					me->iy += dy;
				else
					me->iy = 0;
			}
			else if(me->ix < -dx) {
				me->ix += dx;
				if(me->iy > dy)
					me->iy -= dy;
				else if(me->iy < -dy)
					me->iy += dy;
				else
					me->iy = 0;
			}
			else {
				me->ix = 0;
				if(me->iy > dy)
					me->iy -= dy;
				else if(me->iy < -dy)
					me->iy += dy;
				else
					me->iy = 0;
			}
		}
	}
	*/

	int w = 128, h = 64;

	/*
	if(direction == RIGHT) {
		blit(base, myobj->obj, 0, 0, 0, 0, w, h);
		if(barreldirection == RIGHT)
			draw_sprite(myobj->obj, gunu, 0, 0);
		else
			draw_sprite(myobj->obj, gunul, 0, 0);
	}
	else {
		blit(basel, myobj->obj, 0, 0, 0, 0, w, h);
		if(barreldirection == RIGHT)
			draw_sprite(myobj->obj, gunu, 0, 0);
		else
			draw_sprite(myobj->obj, gunul, 0, 0);
	}
	*/
}

void tank::update() {
	int tmpv;

	if(destroyed) return;

	if(engdir > 0) {
		engramp += engdir;
		if(engramp >= 1) {
			engdir = 0;
			engramp = 1;
		}
	}
	else if(engdir < 0) {
		engramp += engdir;
		if(engramp <= 0) {
			engdir = 0;
			engramp = 0;
		}
	}

	if(occupied) {
		ca = cos(me->ang);
		sa = sin(me->ang);
		rca = -sa;
		rsa = ca;
		ox = x;
		oy = y;
		x = me->x + 0.5 * ca - 4 * rca;
		y = me->y + 0.5 * sa - 4 * rsa;
		mk = me->ang;

		if(!driver->comp) {
			tx = mx;
			ty = my;
		}

		goalang = atan2(ty - y, tx - x) - mk;
		
		if(goalang > pi) goalang -= 2*pi;
		if(goalang > pi * 0.5) goalang = -pi;
		else if(goalang > 0) goalang = 0;
		else if(goalang < -pi) goalang = -pi;
		ca = cos(goalang + mk);
		sa = sin(goalang + mk);
		goalang *= convk;
		mk *= convk;
	}
	else {
		ca = cos(me->ang);
		sa = sin(me->ang);
		rca = -sa;
		rsa = ca;
		ox = x;
		oy = y;
		x = me->x + 0.5 * ca - 4 * rca;
		y = me->y + 0.5 * sa - 4 * rsa;
		mk = me->ang;
		ca = cos(goalang * convk2 + mk);
		sa = sin(goalang * convk2 + mk);
		mk *= convk;
	}

	if(occupied) {
		barrelang = goalang;
		dokeys();
		if(speed > 200) {me->ix *= 0.9; me->iy *= 0.9;}
		if(drawframe % 15 == 0) {
			if(me->iy > 0)
				voice_set_frequency(engvoice, speed * 10 + 10000);
			else
				voice_set_frequency(engvoice, speed * 10 + 10000);
			
			dopanvol(me->x, 0.5);
			voice_set_pan(engvoice, pan);
			voice_set_volume(engvoice, vol * engramp);
		}
		//*/
		//if(voice_check(engstartvoice) != enginestart) dovoices();
	}
	
	if(damage > 700 || me->y > waterlevel) {
		if(occupied) {
			driver->me->iy -= 15;
			driver->me->ix = me->ix * 0.06;
			driver->health -= 50;
			driver->intank = NULL;
			driver->invehicle = false;
			occupied = false;
			driver->me->dtmult = 1;
			driver->abody->dtmult = 1;
		}
		myobj->obj = exp;
		addanimation(explosionanim, 16, me->x - 32, me->y + 32, true, 0, 1, 0);
		addscorch((int)me->x, (int)me->y);
		me->y -= 5;
		me->update();
		destroyvehiclerigidbody(me);
		me = NULL;		
		on = false;
		destroyed = true;
		tmpv = allocate_voice(explode);
		voice_set_priority(tmpv, 255);
		voice_start(tmpv);
		release_voice(tmpv);
		deallocate_voice(engvoice);
		engvoice = NULL;
	}
}

//addanimation(explosionsmallanim, 15, me->x, me->y);

void plane::getin(soldier *newdriver) {
	atom *a;
	noturn = true;
	driver = newdriver;
	me->afric = FLUIDFRICTION;
	if(destroyed) return;
	if(occupied == false) {
		driver->me->dtmult = 0;
		driver->abody->dtmult = 0;
		me->gfric = 0.001;
		sadd = 20;
		me->ram = 0.0003;
		occupied = true;
		if(voice_check(engstartvoice) != propstart) dovoices();
		voice_start(engstartvoice);
		dopanvol(me->x, 0.5);
		voice_set_pan(engstartvoice, pan);
		voice_set_volume(engstartvoice, vol);
		release_voice(engstartvoice);
		engstarted = false;
		voice_set_position(engstartvoice, 0);
		//voice_ramp_volume(engvoice, 100, 255);
		if(!isdamaged) myobj->obj = occ;
		else myobj->obj = damagedo;
		if(driver->side == ENEMY) {
			a = me->atomlist[0];
			for(int i = 0; i < me->mynumatoms; i++) {
				a->levels[1] = true;
				a->levels[5] = false;
				a->levels[14] = false;
				a->level = 12;
				a++;
			}
		}
		else {
			a = me->atomlist[0];
			for(int i = 0; i < me->mynumatoms; i++) {
				a->levels[1] = false;
				a->levels[5] = true;
				a->levels[13] = false;
				a->level = 11;
				a++;
			}			
			keyleft = &(keys['A']);
			keyright = &(keys['D']);
			keyup = &(keys['W']);
			keydown = &(keys['S']);
		}
	}
	else {
		engramp = 0;
		engdir = 0;
		driver->me->dtmult = 1;
		driver->abody->dtmult = 1;
		me->gfric = 0.001;
		me->ram = 0.00005;
		me->ix *= 2;
		me->iy *= 2;
		engspeed += sadd;
		sadd = 0;
		voice_ramp_volume(engvoice, 100, 0);
		occupied = false;
		engstarted = false;
		if(!isdamaged) myobj->obj = unoc;
		else myobj->obj = damaged;
		a = me->atomlist[0];
		for(int i = 0; i < me->mynumatoms; i++) {
			a->levels[1] = false;
			a->levels[5] = false;
			a->levels[7] = false;
			a->level = 7;
			a++;
		}
	}
}

void plane::dokeys() {
	if(destroyed) return;

	if(occupied) {
		//float dx, dy;
		/*
		float astrength = 100;
		float aforce = 3;
		float app;
		float ox, oy, od;
		float ang;
		float goalang;
		float dif;
		*/
		//float speed;
		float tk;
		float rammult;
		rammult = 1;

		if(!engstarted && voice_get_position(engstartvoice) >= 15000) {
			//voice_ramp_volume(engvoice, 300, 255);
			engdir = 0.02;
			engramp = 0;
			engstarted = true;
		}

		if(engstarted) {
			if(*keyup && !*keydown && goalspeed < 0.105) {
				goalspeed += 0.001;
			}
			else if(*keydown && !*keyup && goalspeed > 0.001) {
				goalspeed -= 0.001;
			}
			else if(*keydown && !*keyup) {
				goalspeed = 0;
			}
		}

		me->gmult = 20;

		//engspeed = 0.105;

		
		if(me->y > path[(int)me->x] - 15) {
			//engspeed = 0.2;
			//engspeed = goalspeed * 1.9;
			engspeed = goalspeed;
			//tk = 0.03;
			//tk = 0.001;
			tk = 0.0001 * rammult;
		}
		else {
			engspeed = goalspeed;
			//engspeed = 0.105;
			//tk = 0.0002;
			tk = 0.00015 * rammult;
		}
		if(engspeed == 0.0) {
			me->gfric = 0.001;
		}
		else {
			me->gfric = 0;
		}

		speed = sqrt(me->ix * me->ix + me->iy * me->iy);
		//if(cos(turnang) != 0) speed /= cos(turnang);

		float ang = me->ang * convk;

		if(!inturn) {
			if(direction == RIGHT ) {
				if(speed < 38 && speed > 5) {
					float add = 38 - speed;
					if(ang < -64 || ang > 64) {
						me->ia -= 0.015 * add * rammult;
						//me->ia -= 0.3;
					}
					else {
						me->ia += 0.015 * add * rammult;
						//me->ia += 0.3;
					}
				}
			}
			else {
				if(speed < 38 && speed > 5) {
					float add = 38 - speed;
					if(ang < -64 || ang > 64) {
						me->ia += 0.015 * add * rammult;
						//me->ia += 0.3;
					}
					else {
						me->ia -= 0.015 * add * rammult;
						//me->ia -= 0.3;
					}
				}
			}
		}

		//me->ix += engspeed * dx;
		//me->iy += engspeed * dy;

		if(!inturn) {
			//if(direction == RIGHT) {
				me->ix += engspeed * dx;
				me->iy += engspeed * dy;
			//}
			//else {
				//me->ix -= engspeed * dx;
				//me->iy -= engspeed * dy;
			//}
		}
		else {
			if(direction == RIGHT) {
				me->ix += engspeed * dx * cos(turnang);
				me->iy += engspeed * dy * cos(turnang);
			}
			else {
				me->ix -= engspeed * dx * cos(turnang);
				me->iy -= engspeed * dy * cos(turnang);
			}
		}

		float xs = fabs(me->ix);

		/*
		if(xs < 65) {
			me->iy -= (50 / 65) * xs * GRAVITY;
			4(screen, 0, 0, 10, magenta);
		}
		else {
			me->iy -= 50 * GRAVITY;a
		}
		*/

		//if(me->y > path[(int)me->x] - 10) {me->y = path[(int)me->x] - 10; me->iy = 0;}

		me->ix *= 0.999;
		me->iy *= 0.999;

		float p1, p2, c1, c2;
		float a;
		p1 = me->atomlist[1]->x - me->atomlist[0]->x;
		p2 = me->atomlist[1]->y - me->atomlist[0]->y;
		p1 *= 0.14;
		p2 *= 0.14;

		a = me->ix * p1 + me->iy * p2;
		if(!inturn && speed < 45 && speed > 15) a *= (speed - 15) / 30;
		else if(!inturn && speed < 15) a = 0;
		//a *= 0.08;
		a *= 0.10;
		c1 = -0.5 * a * p1;
		c2 = -0.5 * a * p2;
		me->ix += c1;
		me->iy += c2;

		if(!driver->comp) {
			tx = mx;
			ty = my;
		}
		float goalang, ox, oy;
		ox = tx - me->x;
		oy = ty - me->y;
		if(direction == RIGHT) {
			goalang = atan2(oy, ox);
		}
		else {
			goalang = atan2(-oy, -ox);
		}
		if(me->ang > pi) me->ang -= 2*pi;
		if(me->ang < -pi) me->ang += 2*pi;

		float dif;
		dif = me->ang - goalang;
		if(fabs(dif * convk) > 128) dif = (pi - dif);

		//me->ia = 0;

		/*
		if(fabs(dif) > 0.005 && engspeed > 5) {
			if(dif < 0) {
				me->ang += 0.008;
			}
			else {
				me->ang -= 0.008;
			}
		}
		*/

		me->ia *= 0.99;

		if(!inturn) {
			if(dif < 0) {
				me->ia += tk * speed * speed;
			}
			else {
				me->ia -= tk * speed * speed;
			}
		}
		else {
			if(dif < 0) {
				me->ia += tk * oldspeed * oldspeed * 0.5;
			}
			else {
				me->ia -= tk * oldspeed * oldspeed * 0.5;
			}
		}

		if(!noturn && !inturn && *keyleft && !*keyright) {
			if(direction == RIGHT) {
				direction = LEFT;
				inturn = true;
				float msx, cx;
				mx = 2*me->x - mx;
				msx = (mx - center->x + 600) * (2.0 / 3.0);
				cx = mx - msx;
				if(cx < 0) {
					msx += cx;
				}
				else if(cx > buf->w - 800) {
					msx += (cx - (buf->w - 800));
					//msx -= cx - buf->w + 800;
				}
				if(!driver->comp) position_mouse(msx, 2*me->y - my);
				xch = -(me->ix) / 250;
				ych = -(me->iy) / 250 - 0.1;
				oldspeed = speed;
			}
		}
		else if(!noturn && !inturn && *keyright && !*keyleft) {
			if(direction == LEFT) {
				direction = RIGHT;
				inturn = true;
				float msx, cx;
				mx = 2*me->x - mx;
				msx = (mx - center->x + 600) * (2.0 / 3.0);
				cx = mx - msx;
				if(cx < 0) {
					msx += cx;
				}
				else if(cx > buf->w - 800) {
					msx += (cx - (buf->w - 800));
					//msx -= cx - buf->w + 800;
				}
				if(!driver->comp) position_mouse(msx, 2*me->y - my);
				xch = -(me->ix) / 250;
				ych = -(me->iy) / 250 - 0.1;
				oldspeed = speed;
			}
		}
		else if(!inturn && !*keyleft && !*keyright)
			noturn = false;

		if(inturn) speed = oldspeed;

		/*
		if(*keyup && !*keydown) {
			me->ia += 0.002 * speed;
		}
		else if(*keydown && !*keyup) {
			me->ia -= 0.002 * speed;
		}
		*/

		//speed += 100000000000;
		//speed = 10;
		/*
		me->afric = FLUIDFRICTION;
		
		if(me->y > path[(int)me->x] - 20) {
			me->afric = 0.95;
			me->ix *= 0.995;
		}

		me->ix = 0;
		me->iy = 0;

		if(me->ix > 40) me->ix = 40;
		if(me->ix < -40) me->ix = -40;

		ox = mx - me->x;
		oy = my - me->y;
		od = sqrt(ox * ox + oy * oy);
		if(direction == RIGHT) {
			goalang = atan2(oy, ox);
		}
		else {
			goalang = atan2(-oy, -ox);
		}
		if(me->ang > pi) me->ang -= 2*pi;
		if(me->ang < -pi) me->ang += 2*pi;

		dif = me->ang - goalang;
		if(fabs(dif * convk) > 128) dif = (pi - dif);

		me->ia = 0;

		if(fabs(dif) > 0.005 && engspeed > 5) {
			if(dif < 0) {
				me->ang += 0.008;
			}
			else {
				me->ang -= 0.008;
			}
		}

		if(!inturn) {
			if(direction == RIGHT) {
				me->ix += engspeed * dx;
				me->iy += engspeed * dy;
			}
			else {
				me->ix -= engspeed * dx;
				me->iy -= engspeed * dy;
			}
		}
		else {
			me->ix += engspeed * dx * cos(turnang);
			me->iy += engspeed * dy * cos(turnang);
		}

		if((!inturn && direction == RIGHT) || (inturn && direction == LEFT && turning < 0.5) || (inturn && direction == RIGHT && turning > 0.5)) {
			if(dy < 0)
				engspeed += 0.15 * dy;
			else
				engspeed += 0.3 * dy;
		}
		else {
			if(dy < 0)
				engspeed -= 0.3 * dy;
			else
				engspeed -= 0.15 * dy;
		}

		//if(oy < 0) {
		if(engspeed < goalspeed)
			engspeed += 0.1;
		else if(engspeed > goalspeed)
			engspeed -= 0.1;
		//} 
		engspeed *= 0.9995;

		speed = me->ix * dx + me->iy * dy;

		if(speed > 40) speed = 40;
		if(speed < -40) speed = -40;

		app = fabs(me->ix);
		if(oy > 0)
			app = speed;

		if(speed > 0)
			 me->iy -= 1.75 * (app) * GRAVITY;

		if(me->ang > pi) me->ang -= 2*pi;
		if(me->ang < -pi) me->ang += 2*pi;

		dif = me->ang - goalang;
		if(fabs(dif * convk) > 128) dif = (pi - dif);

		me->ia = 0;

		if(fabs(dif) > 0.005 && engspeed > 5) {
			if(dif < 0) {
				me->ang += 0.008;
			}
			else {
				me->ang -= 0.008;
			}
		}
		else if(engspeed > 5) {
			me->ia = goalang;
		}

		if(!inturn) {
			if(direction == RIGHT ) {
				if(engspeed < 38 && engspeed > 5) {
					float add = 38 - engspeed;
					if(ang < -64 || ang > 64) {
						me->ang -= 0.001 * add;
					}
					else {
						me->ang += 0.001 * add;
					}
				}
			}
			else {
				if(engspeed < 38 && engspeed > 5) {
					float add = 38 - engspeed;
					if(ang < -64 || ang > 64) {
						me->ang += 0.001 * add;
					}
					else {
						me->ang -= 0.001 * add;
					}
				}
			}
		}

		speed = 2 * engspeed + 3 * sadd;

		if(!noturn && !inturn && *keyleft && !*keyright) {
			if(direction == RIGHT) {
				direction = LEFT;
				inturn = true;
				float msx, cx;
				mx = 2*me->x - mx;
				msx = (mx - center->x + 600) * (2.0 / 3.0);
				cx = mx - msx;
				if(cx < 0) {
					msx += cx;
				}
				else if(cx > buf->w - 800) {
					msx += (cx - (buf->w - 800));
					//msx -= cx - buf->w + 800;
				}
				position_mouse(msx, 2*me->y - my);
			}
		}
		else if(!noturn && !inturn && *keyright && !*keyleft) {
			if(direction == LEFT) {
				direction = RIGHT;
				inturn = true;
				float msx, cx;
				mx = 2*me->x - mx;
				msx = (mx - center->x + 600) * (2.0 / 3.0);
				cx = mx - msx;
				if(cx < 0) {
					msx += cx;
				}
				else if(cx > buf->w - 800) {
					msx += (cx - (buf->w - 800));
					//msx -= cx - buf->w + 800;
				}
				position_mouse(msx, 2*me->y - my);
			}
		}
		else if(!inturn && !*keyleft && !*keyright)
			noturn = false;
		*/
		
		if(((rmb && !driver->comp) || (driver->comp && *dropbomb)) && bfired <= 0 && !inturn) {
			float bulletforce = 3;
			if(direction == RIGHT)
				addbomb(me->x + 15 * rx, me->y + 15 * ry, me->ix * 0.025, me->iy * 0.02, driver->side, bombbmp, BOMB);
			else
				addbomb(me->x + 15 * rx, me->y + 15 * ry, me->ix * 0.025, me->iy * 0.02, driver->side, bombbmp, BOMB);
			dopanvol(me->x, 0.25);
			play_sample(bombdrop, vol * .78, pan, 1000, 0);
			bfired = 150;
			//bfired = 60;
		}
		bfired--;

		if(((lmb && !driver->comp) || (driver->comp && *fire)) && fired <= 0 && !inturn) {
			float bulletforce = 3;
			if(voice_check(driver->gunvoice) != mgun) driver->dovoices();
			voice_ramp_volume(driver->gunvoice, 50, 255);
			voice_set_playmode(driver->gunvoice, PLAYMODE_LOOP);
			//if(direction == RIGHT)
			addbullet(me->x + 28 * dx + 6 * rx, me->y + 28 * dy + 6 * ry, bulletforce * dx + 0.025 * me->ix, bulletforce * dy + 0.025 * me->iy, driver->side, 150, 1, 1, black, 0);
			//else
				//addbullet(me->x - 28 * dx + 8 * rx, me->y - 28 * dy + 8 * ry, -bulletforce * dx + 0.025 * me->ix, -bulletforce * dy + 0.025 * me->iy, 0, 150, 1, 1, black, false);
			if(!isdamaged) myobj->obj = firing;
			else myobj->obj = damagedf;
			voice_start(driver->gunvoice);
			fired = 30;
		}
		fired--;
		if(fired <= 5 && myobj->obj == firing) {
			if(occupied) myobj->obj = occ;
			else myobj->obj = unoc;
		}
		else if(fired <= -5 && myobj->obj == damagedf) {
			if(occupied) myobj->obj = damagedo;
			else myobj->obj = damaged;
		}
		if(fired < -5) {
			voice_ramp_volume(driver->gunvoice, 50, 0);
		}
	}
	/*
	else {
		me->afric = 0.95;
		if(me->y > path[(int)me->x] - 20) {
			me->ix *= 0.995;
		}
	}
	*/
}

void plane::setdirection(bool newdir) {	
	atom *a;
	int i;
	float dist;
	float tdx, tdy, m, om, ox, oy, od;
	if(newdir != direction) {
		direction = newdir;
		for(i = 0; i < me->mynumatoms - 2; i++) {
			a = me->atomlist[i];
			//dx = a->x - me->x;
			//dy = a->y - me->y;
			tdx = -me->offset[i][0];
			tdy = me->offset[i][1];

			me->offset[i][0] = tdx;
			me->offset[i][1] = tdy;
			dist = sqrt(tdx * tdx + tdy * tdy);
			me->ol[i] = dist;
			m = tdy / tdx;
			if(m != 0) {
				om = (-1) / m;
				ox = 1;
				oy = om;
			}
			else {
				om = 0;
				ox = 0;
				oy = 1;
			}
			od = sqrt(1 + oy * oy);
			ox = ox / od;
			oy = oy / od;
			if(tdy > 0) {
				ox = -ox;
				oy = -oy;
			}
			me->ouv[i][0] = ox;
			me->ouv[i][1] = oy;
		}

		turning = 1;
		//me->ix += xch;
		//me->iy += ych;
		turnang = turning * pi + pi;
		tcos = cos(turnang);
		me->turning = tcos;
		if(turning >= 1) {
			turning = 0;
			inturn = false;
		}
		i = 18;
		a = me->atomlist[i];
		//dx = a->x - me->x;
		//dy = a->y - me->y;
		if(direction == LEFT) turnang -= pi;
		tdx = 15 * cos(turnang);
		tdy = 11;

		me->offset[i][0] = tdx;
		me->offset[i][1] = tdy;
		dist = sqrt(tdx * tdx + tdy * tdy);
		me->ol[i] = dist;
		m = tdy / tdx;
		if(m != 0) {
			om = (-1) / m;
			ox = 1;
			oy = om;
		}
		else {
			om = 0;
			ox = 0;
			oy = 1;
		}
		od = sqrt(1 + oy * oy);
		ox = ox / od;
		oy = oy / od;
		if(tdy > 0) {
			ox = -ox;
			oy = -oy;
		}
		me->ouv[i][0] = ox;
		me->ouv[i][1] = oy;

		
		i = 19;		
		a = me->atomlist[i];
		//dx = a->x - me->x;
		//dy = a->y - me->y;
		tdx = -15 * cos(turnang);
		//if(direction == LEFT) tdx = -tdx;
		tdy = 9;
		me->offset[i][0] = tdx;
		me->offset[i][1] = tdy;
		dist = sqrt(tdx * tdx + tdy * tdy);
		me->ol[i] = dist;
		m = tdy / tdx;
		if(m != 0) {
			om = (-1) / m;
			ox = 1;
			oy = om;
		}
		else {
			om = 0;
			ox = 0;
			oy = 1;
		}
		od = sqrt(1 + oy * oy);
		ox = ox / od;
		oy = oy / od;
		if(tdy > 0) {
			ox = -ox;
			oy = -oy;
		}
		me->ouv[i][0] = ox;
		me->ouv[i][1] = oy;
		//a->r = this;
	}
}

void plane::update() {
	int tmpv;

	if(destroyed) return;
	dx = me->atomlist[5]->x - me->atomlist[2]->x;
	dy = me->atomlist[5]->y - me->atomlist[2]->y;
	rx = me->atomlist[2]->x - me->atomlist[1]->x;
	ry = me->atomlist[2]->y - me->atomlist[1]->y;
	dx *= 0.1;
	dy *= 0.1;
	rx *= 0.1;
	ry *= 0.1;
	dokeys();

	if(engdir > 0) {
		engramp += engdir;
		if(engramp >= 1) {
			engdir = 0;
			engramp = 1;
		}
	}
	else if(engdir < 0) {
		engramp += engdir;
		if(engramp <= 0) {
			engdir = 0;
			engramp = 0;
		}
	}

	/*
	if(me->y > waterlevel) {
		me->iy -= 70 * GRAVITY;
	}
	else {
		me->iy += 70 * GRAVITY;
	}
	*/

	if(inturn) {
		atom *a;
		int i;
		float dist;
		float tdx, tdy, m, om, ox, oy, od;
		if(turning == 0) {
			for(i = 0; i < me->mynumatoms - 2; i++) {
				a = me->atomlist[i];
				//dx = a->x - me->x;
				//dy = a->y - me->y;
				tdx = -me->offset[i][0];
				tdy = me->offset[i][1];

				me->offset[i][0] = tdx;
				me->offset[i][1] = tdy;
				dist = sqrt(tdx * tdx + tdy * tdy);
				me->ol[i] = dist;
				m = tdy / tdx;
				if(m != 0) {
					om = (-1) / m;
					ox = 1;
					oy = om;
				}
				else {
					om = 0;
					ox = 0;
					oy = 1;
				}
				od = sqrt(1 + oy * oy);
				ox = ox / od;
				oy = oy / od;
				if(tdy > 0) {
					ox = -ox;
					oy = -oy;
				}
				me->ouv[i][0] = ox;
				me->ouv[i][1] = oy;
			}
		}

		turning += 0.002;
		me->ix += xch;
		me->iy += ych;
		if(turning > 1) turning = 1;
		//if(direction == LEFT) {
			//turnang = turning * pi;
		//}
		//else if(direction == RIGHT) {
			turnang = turning * pi + pi;
		//}
		tcos = cos(turnang);
		me->turning = tcos;
		if(turning >= 1) {
			turning = 0;
			inturn = false;
		}


		i = 18;
		a = me->atomlist[i];
		//dx = a->x - me->x;
		//dy = a->y - me->y;
		if(direction == LEFT) turnang -= pi;
		tdx = 15 * cos(turnang);
		tdy = 11;

		me->offset[i][0] = tdx;
		me->offset[i][1] = tdy;
		dist = sqrt(tdx * tdx + tdy * tdy);
		me->ol[i] = dist;
		m = tdy / tdx;
		if(m != 0) {
			om = (-1) / m;
			ox = 1;
			oy = om;
		}
		else {
			om = 0;
			ox = 0;
			oy = 1;
		}
		od = sqrt(1 + oy * oy);
		ox = ox / od;
		oy = oy / od;
		if(tdy > 0) {
			ox = -ox;
			oy = -oy;
		}
		me->ouv[i][0] = ox;
		me->ouv[i][1] = oy;

		
		i = 19;		
		a = me->atomlist[i];
		//dx = a->x - me->x;
		//dy = a->y - me->y;
		tdx = -15 * cos(turnang);
		//if(direction == LEFT) tdx = -tdx;
		tdy = 9;
		me->offset[i][0] = tdx;
		me->offset[i][1] = tdy;
		dist = sqrt(tdx * tdx + tdy * tdy);
		me->ol[i] = dist;
		m = tdy / tdx;
		if(m != 0) {
			om = (-1) / m;
			ox = 1;
			oy = om;
		}
		else {
			om = 0;
			ox = 0;
			oy = 1;
		}
		od = sqrt(1 + oy * oy);
		ox = ox / od;
		oy = oy / od;
		if(tdy > 0) {
			ox = -ox;
			oy = -oy;
		}
		me->ouv[i][0] = ox;
		me->ouv[i][1] = oy;
		//a->r = this;
	}

	/*
	if(engspeed < 38) {
		float dif;
		dif = 38 - engspeed;
		if(dif > 15) dif = 15;
		me->y += 0.03 * dif;
	}
	*/

	if(occupied) {
		//if(me->ix * me->ix + me->iy * me->iy > 1600) me->ix *= 0.9;
		//if(me->iy > 0)
			//voice_set_frequency(engvoice, (speed + me->iy) * 100 + 10000);
		//else

		if(drawframe % 15 == 0 || (engramp <  1 && drawframe % 3 == 0)) {
			voice_set_frequency(engvoice, speed * 100 + 8000);
			
			dopanvol(me->x, 0.2);
			voice_set_pan(engvoice, pan);
			voice_set_volume(engvoice, vol * engramp);
		}

		//if(voice_check(engstartvoice) != propstart) dovoices();
	}
	else {
		engspeed -= 0.1;
		if(engspeed < 0) engspeed = 0;
		goalspeed = 0;
	}
	if(me->y >= waterlevel - 5) {
		if(occupied) {
			driver->me->iy -= 1;
			driver->me->ix = me->ix * 0.1;
			//driver->health -= 50;
			driver->inplane = NULL;
			driver->invehicle = false;
			driver->me->dtmult = 1;
			driver->abody->dtmult = 1;
			occupied = false;
		}
		myobj->obj = exp;
		/*
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addanimation(explosionanim, 16, me->x - 32, me->y - 32, true, 0, 1, 0);
		*/
		me->y -= 5;
		me->update();
		me->gmult = 70;
		me->ix *= 0.3;
		me->iy *= 0.3;
		destroyvehiclerigidbody(me);
		me = NULL;
		destroyed = true;
		on = false;
		tmpv = allocate_voice(gurgle);
		voice_set_priority(tmpv, 255);
		voice_start(tmpv);
		release_voice(tmpv);
		deallocate_voice(engvoice);
		engvoice = NULL;
	}
	else if(damage > 200) {
		if(occupied) {
			driver->me->dtmult = 1;
			driver->abody->dtmult = 1;
			driver->me->iy -= 5;
			driver->me->ix = me->ix * 0.3;
			driver->health -= 50;
			driver->inplane = NULL;
			driver->invehicle = false;
			occupied = false;
		}
		myobj->obj = exp;
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addanimation(explosionanim, 16, me->x - 32, me->y + 32, true, 0, 1, 0);
		me->y -= 5;
		me->update();
		me->gmult = 70;
		for(int i = 0; i < me->mynumatoms; i++) {
			me->atomlist[i]->levels[me->atomlist[i]->level] = true;
		}
		destroyvehiclerigidbody(me);
		destroyatom(me->atomlist[17]);
		destroyatom(me->atomlist[18]);
		me = NULL;
		destroyed = true;
		on = false;
		tmpv = allocate_voice(explode);
		voice_set_priority(tmpv, 255);
		voice_start(tmpv);
		release_voice(tmpv);
		deallocate_voice(engvoice);
		engvoice = NULL;
	}
	else if(damage > 100 && isdamaged == false) {
		isdamaged = true;
		if(occupied) myobj->obj = damagedo;
		else myobj->obj = damaged;
	}
	if(!destroyed && isdamaged && dispframe) addanimation(smokeanim, 24, me->polylistx[1] - 15 + 3*rx, me->polylisty[1] + 15 - 3*ry, true, -1, 1, 20);//addanimation(smokeanim, 24, me->polylistx[1] - 15 - 3*dx*tcos + 3*rx, me->polylisty[1] - 15 - 3*dy*tcos + 3*ry, true, -1, 1, 20);
}


void heli::dokeys() {
	if(destroyed) return;

	if(occupied) {
		//float dx, dy;
		/*
		float astrength = 100;
		float aforce = 3;
		float app;
		float ox, oy, od;
		float ang;
		float goalang;
		float dif;
		*/
		//float speed;

		

		float tk;
		float rammult;
		rammult = 1;

		//if(driver->comp) fprintf(debug, "heli: (frame %i) %i,%i,%i,%i,%f,%f\n", frame, *keyup,*keydown,*keyleft,*keyright,tx,ty);
		//else fprintf(debug, "heli: (frame %i) %i,%i,%i,%i,%f,%f\n", frame, -*keyup,-*keydown,-*keyleft,-*keyright,tx,ty);

		if(!engstarted && engstartcount > 80) {//voice_get_position(engstartvoice) >= 15000) {
			//voice_ramp_volume(engvoice, 300, 255);
			engdir = 0.02;
			engramp = 0;
			engstarted = true;
			engstartcount = 0;
		}
		else if(!engstarted)
			engstartcount++;
		//engstarted = true;

		if(engstarted) {
			if(*keyup && !*keydown && goalspeed < 0.2) {
				goalspeed += 0.001;
			}
			else if(*keydown && !*keyup && goalspeed > 0.001) {
				goalspeed -= 0.001;
			}
			else if(*keydown && !*keyup) {
				goalspeed = 0;
			}
		}

		//me->gmult = 20;

		engspeed = goalspeed;
		tk = 0.5 * rammult;

		/*
		if(engspeed == 0.0) {
			me->gfric = 0.001;
		}
		else {
			me->gfric = 0;
		}
		*/

		speed = engspeed + 0.002*sqrt(me->ix * me->ix + me->iy * me->iy);

		float ang = me->ang * convk;

		me->ix -= engspeed * rx;
		me->iy -= engspeed * ry;

		me->ix *= 0.999;
		me->iy *= 0.999;

		if(!driver->comp) {
			tx = mx;
			ty = my;
		}
		float goalang, ox, oy;

		ox = tx - me->x;
		oy = ty - me->y;
		if(direction == RIGHT) {
			goalang = atan2(oy, ox);
		}
		else {
			goalang = atan2(-oy, -ox);
		}
		if(me->ang > pi) me->ang -= 2*pi;
		if(me->ang < -pi) me->ang += 2*pi;

		float dif;
		dif = me->ang - goalang;
		if(fabs(dif * convk) > 128) dif = (pi - dif);

		me->ia *= 0.99;

		if(dif < 0) {
			me->ia += tk;
		}
		else {
			me->ia -= tk;
		}

		if(!noturn && !inturn && *keyleft && !*keyright) {
			if(direction == RIGHT) {
				direction = LEFT;
				inturn = true;
				float msx, cx;
				mx = 2*me->x - mx;
				msx = (mx - center->x + 600) * (2.0 / 3.0);
				cx = mx - msx;
				if(cx < 0) {
					msx += cx;
				}
				else if(cx > buf->w - 800) {
					msx += (cx - (buf->w - 800));
					//msx -= cx - buf->w + 800;
				}
				if(!driver->comp) position_mouse(msx, my);//2*me->y - my);
				xch = -(me->ix) / 250;
				ych = -(me->iy) / 250 - 0.1;
			}
		}
		else if(!noturn && !inturn && *keyright && !*keyleft) {
			if(direction == LEFT) {
				direction = RIGHT;
				inturn = true;
				float msx, cx;
				mx = 2*me->x - mx;
				msx = (mx - center->x + 600) * (2.0 / 3.0);
				cx = mx - msx;
				if(cx < 0) {
					msx += cx;
				}
				else if(cx > buf->w - 800) {
					msx += (cx - (buf->w - 800));
					//msx -= cx - buf->w + 800;
				}
				if(!driver->comp) position_mouse(msx, my);//2*me->y - my);
				xch = -(me->ix) / 250;
				ych = -(me->iy) / 250 - 0.1;
			}
		}
		else if(!inturn && !*keyleft && !*keyright)
			noturn = false;

		if(((rmb && !driver->comp) || (driver->comp && *dropbomb)) && bfired <= 0 && !inturn) {
			float bulletforce = 3;
			bomb *b;

			/*
			if(direction == RIGHT)
				b = addbomb(me->x + 0 * dx + 6 * rx, me->y + 0 * dy + 6 * ry, me->ix * 0.025 + 4 * dx, me->iy * 0.02 + 4 * dy, driver->side, missilebmp, MISSILE);
			else
				b = addbomb(me->x + 0 * dx + 6 * rx, me->y + 0 * dy + 6 * ry, me->ix * 0.025 + 4 * dx, me->iy * 0.02 + 4 * dy, driver->side, missilebmp, MISSILE);
			*/
			if(direction == RIGHT)
				b = addbomb(me->x + 0 * dx + 6 * rx, me->y + 0 * dy + 6 * ry, 4 * dx, 4 * dy, driver->side, missilebmp, MISSILE);
			else
				b = addbomb(me->x + 0 * dx + 6 * rx, me->y + 0 * dy + 6 * ry, 4 * dx, 4 * dy, driver->side, missilebmp, MISSILE);
			
			//addtrailanim(a, anim, frames, mod, modoff, life, dy, rand, trans, delay);
			//addtrailanim(b->me, misstrailanim, 9, 5, 0, 500, 0, 1, false, 1);
			addtrailanim(b->me, whiteanim, 24, 1, 0, 500, 0, 1, true, -2);
			
			//addanimation(whiteanim, 24, x + offset * ca - 15, y + offset * sa - 15, true, -0.1, 1, 1);

			dopanvol(me->x, 0.25);
			play_sample(bombdrop, vol * .78, pan, 1000, 0);
			bfired = 150;
			//bfired = 60;
		}
		bfired--;

		if(((lmb && !driver->comp) || (driver->comp && *fire)) && fired <= 0 && !inturn) {
			float bulletforce = 3;
			if(voice_check(driver->gunvoice) != mgun) driver->dovoices();
			voice_ramp_volume(driver->gunvoice, 50, 255);
			voice_set_playmode(driver->gunvoice, PLAYMODE_LOOP);
			//if(direction == RIGHT)
				addbullet(me->x + 28 * dx + 6 * rx, me->y + 28 * dy + 6 * ry, bulletforce * dx + 0.025 * me->ix, bulletforce * dy + 0.025 * me->iy, 0, 150, 1, 1, black, driver->side);
			if(!isdamaged) myobj->obj = firing;
			else myobj->obj = damagedf;
			voice_start(driver->gunvoice);
			fired = 30;
		}
		fired--;
		if(fired <= 5 && myobj->obj == firing) {
			if(occupied) myobj->obj = occ;
			else myobj->obj = unoc;
		}
		else if(fired <= -5 && myobj->obj == damagedf) {
			if(occupied) myobj->obj = damagedo;
			else myobj->obj = damaged;
		}
		if(fired < -5) {
			voice_ramp_volume(driver->gunvoice, 50, 0);
		}
	}
}

void heli::getin(soldier *newdriver) {
	atom *a;
	noturn = true;
	driver = newdriver;
	me->afric = FLUIDFRICTION;
	if(destroyed) return;
	if(occupied == false) {
		engramp = 0;
		driver->me->dtmult = 0;
		driver->abody->dtmult = 0;
		//me->gfric = 0.001;
		sadd = 20;
		me->ram = 0.0003;
		occupied = true;
		if(voice_check(engstartvoice) != propstart) dovoices();
		voice_start(engstartvoice);
		engstartcount = 0;
		dopanvol(me->x, 0.5);
		voice_set_pan(engstartvoice, pan);
		voice_set_volume(engstartvoice, vol);
		release_voice(engstartvoice);
		engstarted = false;
		voice_set_position(engstartvoice, 0);
		//voice_ramp_volume(engvoice, 100, 255);
		if(!isdamaged) myobj->obj = occ;
		else myobj->obj = damagedo;
		if(driver->side == ENEMY) {
			a = me->atomlist[0];
			for(int i = 0; i < me->mynumatoms; i++) {
				a->levels[1] = true;
				a->levels[5] = false;
				a->levels[14] = false;
				a->level = 12;
				a++;
			}
		}
		else {
			a = me->atomlist[0];
			for(int i = 0; i < me->mynumatoms; i++) {
				a->levels[1] = false;
				a->levels[5] = true;
				a->levels[13] = false;
				a->level = 11;
				a++;
			}			
			keyleft = &(keys['A']);
			keyright = &(keys['D']);
			keyup = &(keys['W']);
			keydown = &(keys['S']);
		}
		if(driver->comp) {
			dropbomb = &(driver->controller->dropbomb);
			keyleft = &(driver->controller->goleft);
			keyright = &(driver->controller->goright);
			keyup = &(driver->controller->goup);
			fire = &(driver->controller->fire);
			keydown = &(driver->controller->godown);
		}
	}
	else {
		engramp = 0;
		engdir = 0;
		driver->me->dtmult = 1;
		driver->abody->dtmult = 1;
		//me->gfric = 0.001;
		me->ram = 0.00005;
		me->ix *= 2;
		me->iy *= 2;
		engspeed += sadd;
		sadd = 0;
		voice_ramp_volume(engvoice, 100, 0);
		occupied = false;
		engstarted = false;
		if(!isdamaged) myobj->obj = unoc;
		else myobj->obj = damaged;
		a = me->atomlist[0];
		for(int i = 0; i < me->mynumatoms; i++) {
			a->levels[1] = false;
			a->levels[5] = false;
			a->levels[7] = false;
			a->level = 7;
			a++;
		}
	}
}

void heli::setdirection(bool newdir) {	
	atom *a;
	int i;
	float dist;
	float tdx, tdy, m, om, ox, oy, od;
	if(newdir != direction) {
		direction = newdir;
		for(i = 0; i < me->mynumatoms - 2; i++) {
			a = me->atomlist[i];

			tdx = -me->offset[i][0];
			tdy = me->offset[i][1];

			me->offset[i][0] = tdx;
			me->offset[i][1] = tdy;
			dist = sqrt(tdx * tdx + tdy * tdy);
			me->ol[i] = dist;
			m = tdy / tdx;
			if(m != 0) {
				om = (-1) / m;
				ox = 1;
				oy = om;
			}
			else {
				om = 0;
				ox = 0;
				oy = 1;
			}
			od = sqrt(1 + oy * oy);
			ox = ox / od;
			oy = oy / od;
			if(tdy > 0) {
				ox = -ox;
				oy = -oy;
			}
			me->ouv[i][0] = ox;
			me->ouv[i][1] = oy;
		}

		turning = 1;
		//me->ix += xch;
		//me->iy += ych;
		turnang = turning * pi + pi;
		tcos = cos(turnang);
		me->turning = tcos;
		if(turning >= 1) {
			turning = 0;
			inturn = false;
		}
		i = 18;
		a = me->atomlist[i];
		//dx = a->x - me->x;
		//dy = a->y - me->y;
		if(direction == LEFT) turnang -= pi;
		tdx = 15 * cos(turnang);
		tdy = 11;

		me->offset[i][0] = tdx;
		me->offset[i][1] = tdy;
		dist = sqrt(tdx * tdx + tdy * tdy);
		me->ol[i] = dist;
		m = tdy / tdx;
		if(m != 0) {
			om = (-1) / m;
			ox = 1;
			oy = om;
		}
		else {
			om = 0;
			ox = 0;
			oy = 1;
		}
		od = sqrt(1 + oy * oy);
		ox = ox / od;
		oy = oy / od;
		if(tdy > 0) {
			ox = -ox;
			oy = -oy;
		}
		me->ouv[i][0] = ox;
		me->ouv[i][1] = oy;

		
		i = 19;		
		a = me->atomlist[i];
		//dx = a->x - me->x;
		//dy = a->y - me->y;
		tdx = -15 * cos(turnang);
		//if(direction == LEFT) tdx = -tdx;
		tdy = 9;
		me->offset[i][0] = tdx;
		me->offset[i][1] = tdy;
		dist = sqrt(tdx * tdx + tdy * tdy);
		me->ol[i] = dist;
		m = tdy / tdx;
		if(m != 0) {
			om = (-1) / m;
			ox = 1;
			oy = om;
		}
		else {
			om = 0;
			ox = 0;
			oy = 1;
		}
		od = sqrt(1 + oy * oy);
		ox = ox / od;
		oy = oy / od;
		if(tdy > 0) {
			ox = -ox;
			oy = -oy;
		}
		me->ouv[i][0] = ox;
		me->ouv[i][1] = oy;
		//a->r = this;
	}
}

void heli::update() {
	int tmpv;

	if(destroyed) return;
	dx = me->atomlist[4]->x - me->atomlist[1]->x;
	dy = me->atomlist[4]->y - me->atomlist[1]->y;
	rx = me->atomlist[1]->x - me->atomlist[0]->x;
	ry = me->atomlist[1]->y - me->atomlist[0]->y;
	dx *= 0.1;
	dy *= 0.1;
	rx *= 0.1;
	ry *= 0.1;
	dokeys();

	if(engdir > 0) {
		engramp += engdir;
		if(engramp >= 1) {
			engdir = 0;
			engramp = 1;
		}
	}
	else if(engdir < 0) {
		engramp += engdir;
		if(engramp <= 0) {
			engdir = 0;
			engramp = 0;
		}
	}

	if(occupied && !driver->comp && 0) {
		accx += mouse_x - omouse_x;
		accy += mouse_y - omouse_y;

		nmouse_x = me->x + accx;
		nmouse_y = me->y + accy;
		//position_mouse(me->x + accx - lx, me->y + accy);

		omouse_x = mouse_x;
		omouse_y = mouse_y;
	}

		//accx -= (int)(accx - 1.5);
		//accy -= (int)(accy - 1.5);

		//accx = accy = .5;
		//accy = 0.5;
		//accx = 0;



	//}

	/*
	if(me->y > waterlevel) {
		me->iy -= 70 * GRAVITY;
	}
	else {
		me->iy += 70 * GRAVITY;
	}
	*/

	if(inturn) {
		atom *a;
		int i;
		float dist;
		float tdx, tdy, m, om, ox, oy, od;
		if(turning == 0) {
			for(i = 0; i < me->mynumatoms; i++) {
				a = me->atomlist[i];
				//dx = a->x - me->x;
				//dy = a->y - me->y;
				tdx = -me->offset[i][0];
				tdy = me->offset[i][1];

				me->offset[i][0] = tdx;
				me->offset[i][1] = tdy;
				dist = sqrt(tdx * tdx + tdy * tdy);
				me->ol[i] = dist;
				m = tdy / tdx;
				if(m != 0) {
					om = (-1) / m;
					ox = 1;
					oy = om;
				}
				else {
					om = 0;
					ox = 0;
					oy = 1;
				}
				od = sqrt(1 + oy * oy);
				ox = ox / od;
				oy = oy / od;
				if(tdy > 0) {
					ox = -ox;
					oy = -oy;
				}
				me->ouv[i][0] = ox;
				me->ouv[i][1] = oy;
			}
		}

		turning += 0.002;

		//me->ix += xch;

		if(turning > 1) turning = 1;
		
		turnang = turning * pi + pi;
		tcos = cos(turnang);
		me->turning = tcos;
		if(turning >= 1) {
			turning = 0;
			inturn = false;
		}
	}

	if(occupied) {
		if(drawframe % 15 == 0 || (engramp <  1 && drawframe % 3 == 0)) {
			voice_set_frequency(engvoice, speed * 10000 + 8000);
			
			dopanvol(me->x, 0.2);
			voice_set_pan(engvoice, pan);
			voice_set_volume(engvoice, vol * engramp);
		}
	}
	else {
		engspeed -= 0.1;
		if(engspeed < 0) engspeed = 0;
		goalspeed = 0;
	}
	if(me->y >= waterlevel - 5) {
		if(occupied) {
			driver->me->iy -= 1;
			driver->me->ix = me->ix * 0.1;
			//driver->health -= 50;
			driver->inheli = NULL;
			driver->invehicle = false;
			driver->me->dtmult = 1;
			driver->abody->dtmult = 1;
			occupied = false;
		}
		myobj->obj = exp;
		/*
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addanimation(explosionanim, 16, me->x - 32, me->y - 32, true, 0, 1, 0);
		*/
		me->y -= 5;
		me->update();
		//me->gmult = 70;
		me->ix *= 0.3;
		me->iy *= 0.3;
		destroyvehiclerigidbody(me);
		me = NULL;
		destroyed = true;
		tmpv = allocate_voice(gurgle);
		voice_set_priority(tmpv, 255);
		voice_start(tmpv);
		release_voice(tmpv);
		deallocate_voice(engvoice);
		engvoice = NULL;
	}
	else if(damage > 200) {
		if(occupied) {
			driver->me->dtmult = 1;
			driver->abody->dtmult = 1;
			driver->me->iy -= 5;
			driver->me->ix = me->ix * 0.3;
			driver->health -= 50;
			driver->inheli = NULL;
			driver->invehicle = false;
			occupied = false;
		}
		myobj->obj = exp;
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[7], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addtrailanim(me->atomlist[10], explosionsmallanim, 24, 10, rand() % 10, 1500 + rand() % 1500, -2, 5, false, 1);
		addanimation(explosionanim, 16, me->x - 32, me->y + 32, true, 0, 1, 0);
		me->y -= 5;
		me->update();
		//me->gmult = 70;
		for(int i = 0; i < me->mynumatoms; i++) {
			me->atomlist[i]->levels[me->atomlist[i]->level] = true;
		}
		destroyvehiclerigidbody(me);
		destroyatom(me->atomlist[17]);
		destroyatom(me->atomlist[18]);
		me = NULL;
		destroyed = true;
		tmpv = allocate_voice(explode);
		voice_set_priority(tmpv, 255);
		voice_start(tmpv);
		release_voice(tmpv);
		deallocate_voice(engvoice);
		engvoice = NULL;
	}
	else if(damage > 100 && isdamaged == false) {
		isdamaged = true;
		if(occupied) myobj->obj = damagedo;
		else myobj->obj = damaged;
	}
	if(!destroyed && isdamaged && dispframe) addanimation(smokeanim, 24, me->polylistx[15] - 15, me->polylisty[15] + 15, true, -2, 1, 20);//addanimation(smokeanim, 24, me->polylistx[1] - 15 - 3*dx*tcos + 3*rx, me->polylisty[1] - 15 - 3*dy*tcos + 3*ry, true, -1, 1, 20);
}

void updatesoldiers() {
	int i;
	soldier *s;
	
	s = &(soldiers[0]);
	for(i = 0; i < numsoldiers; i++) {
		s->update();
		s++;
	}
}

void updatecompsoldiers() {
	int i;
	compsoldier *s;
	
	s = &(compsoldiers[0]);
	for(i = 0; i < numcompsoldiers; i++) {
		s->update();
		s++;
	}
}

void drawsoldiers() {
	int i;
	soldier *s;
	
	s = &(soldiers[0]);
	for(i = 0; i < numsoldiers; i++) {
		s->draw();
		s++;
	}
}

void erasesoldiers() {
	int i;
	soldier *s;
	
	s = &(soldiers[0]);
	for(i = 0; i < numsoldiers; i++) {
		s->erase();
		s++;
	}
}

soldier *addsoldier() {
	soldier *s;
	/*
	s = &(soldiers[numsoldiers]);
	numsoldiers++;
	return s;
	*/

	s = &(soldiers[0]);
	while(!s->dead) s++;
	s->reset();
	s->dead = false;
	if(s == &(soldiers[numsoldiers]))
		numsoldiers++;
	return s;
}

compsoldier *addcompsoldier() {
	compsoldier *c;
	/*
	c = &(compsoldiers[numcompsoldiers]);
	numcompsoldiers++;
	return c;
	*/
	c = &(compsoldiers[0]);
	while(c->me && !c->me->dead) c++;
	c->reset();
	if(c == &(compsoldiers[numcompsoldiers]))
		numcompsoldiers++;
	return c;
}

compsoldier *addcompsoldier(float x, float y, bool side) {
	soldier *s;
	atom *a;
	compsoldier *c;
	settmplevels();
	if(side == ENEMY) {
		tmplevels[1] = false;
		tmplevels[4] = false;
		tmplevels[5] = false;
		tmplevels[6] = false;
		tmplevels[7] = false;
		tmplevels[12] = false;
		tmplevels[14] = false;		

		tmplevels[16] = false;
		tmplevels[17] = false;
		tmplevels[18] = false;
		tmplevels[19] = false;

		a = addatom(x, y, tmplevels, 5);
	}
	else if(side == FRIEND) {
		tmplevels[1] = false;
		tmplevels[3] = false;
		tmplevels[4] = false;
		tmplevels[5] = false;
		tmplevels[7] = false;
		tmplevels[11] = false;
		tmplevels[13] = false;

		tmplevels[16] = false;
		tmplevels[17] = false;
		tmplevels[18] = false;
		tmplevels[19] = false;

		a = addatom(x, y, tmplevels, 1);
	}
	s = addsoldier();
	c = addcompsoldier();
	a->rmdt = 0.23;
	s->comp = true;
	s->init(a, side);
	c->init(s, side);
	return c;
}
